/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.fao.geonet.domain.UserSavedSelection;
import org.fao.geonet.domain.UserSavedSelectionId_;
import org.fao.geonet.domain.UserSavedSelection_;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserSavedSelectionRepositoryCustom;
import org.springframework.transaction.annotation.Transactional;

public class UserSavedSelectionRepositoryCustomImpl
implements UserSavedSelectionRepositoryCustom {
    @PersistenceContext
    private EntityManager _entityManager;

    @Override
    public List<Integer> findAllUsers(Integer selectionId) {
        CriteriaBuilder builder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(UserSavedSelection.class);
        Root root = query.from(UserSavedSelection.class);
        Path integerPath = root.get(UserSavedSelection_.id).get(UserSavedSelectionId_.userId);
        query.select((Selection)integerPath);
        query.distinct(true);
        ParameterExpression selectionParam = builder.parameter(Integer.class, "selectionParam");
        query.where((Expression)builder.equal((Expression)selectionParam, (Expression)root.get(UserSavedSelection_.id).get(UserSavedSelectionId_.selectionId)));
        List umsResults = this._entityManager.createQuery(query).setParameter("selectionParam", (Object)selectionId).getResultList();
        return umsResults;
    }

    @Override
    public List<String> findMetadataUpdatedAfter(Integer selectionId, Integer userId, String lastNotificationDate, String nextLastNotificationDate) {
        Query query = this._entityManager.createNativeQuery("SELECT DISTINCT metadataUuid FROM UserSavedSelections u, Metadata m WHERE u.selectionId = :selectionId AND u.userId = :userId AND u.metadataUuid = m.uuid AND m.changeDate >= :lastNotificationDate AND m.changeDate < :nextLastNotificationDate");
        query.setParameter("selectionId", (Object)selectionId);
        query.setParameter("userId", (Object)userId);
        query.setParameter("lastNotificationDate", (Object)lastNotificationDate);
        query.setParameter("nextLastNotificationDate", (Object)nextLastNotificationDate);
        return query.getResultList();
    }

    @Override
    public List<String> findMetadata(Integer selectionId, Integer userId) {
        CriteriaBuilder builder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(UserSavedSelection.class);
        Root root = query.from(UserSavedSelection.class);
        ParameterExpression selectionParam = builder.parameter(Integer.class, "selectionParam");
        ParameterExpression userParam = builder.parameter(Integer.class, "userParam");
        query.where((Expression)builder.and((Expression)builder.equal((Expression)selectionParam, (Expression)root.get(UserSavedSelection_.id).get(UserSavedSelectionId_.selectionId)), (Expression)builder.equal((Expression)userParam, (Expression)root.get(UserSavedSelection_.id).get(UserSavedSelectionId_.userId))));
        List umsResults = this._entityManager.createQuery(query).setParameter("selectionParam", (Object)selectionId).setParameter("userParam", (Object)userId).getResultList();
        ArrayList<String> result = new ArrayList<String>();
        umsResults.forEach(e -> result.add(e.getId().getMetadataUuid()));
        return result;
    }

    @Override
    @Transactional
    public int deleteAllBySelection(Integer selectionId) {
        String selectionIdPath = SortUtils.createPath(UserSavedSelection_.id, UserSavedSelectionId_.selectionId);
        String qlString = String.format("DELETE FROM UserSavedSelection WHERE %s = :selectionId", selectionIdPath);
        int deleted = this._entityManager.createQuery(qlString).setParameter("selectionId", (Object)selectionId).executeUpdate();
        this._entityManager.flush();
        this._entityManager.clear();
        return deleted;
    }

    @Override
    @Transactional
    public int deleteAllByUser(Integer userId) {
        String userIdPath = SortUtils.createPath(UserSavedSelection_.id, UserSavedSelectionId_.userId);
        String qlString = String.format("DELETE FROM UserSavedSelection WHERE %s = :userId", userIdPath);
        int deleted = this._entityManager.createQuery(qlString).setParameter("userId", (Object)userId).executeUpdate();
        this._entityManager.flush();
        this._entityManager.clear();
        return deleted;
    }

    @Override
    @Transactional
    public int deleteAllByUuid(String metadataUuid) {
        String metadataUuidPath = SortUtils.createPath(UserSavedSelection_.id, UserSavedSelectionId_.metadataUuid);
        String qlString = String.format("DELETE FROM UserSavedSelection WHERE %s = :metadataUuid", metadataUuidPath);
        int deleted = this._entityManager.createQuery(qlString).setParameter("metadataUuid", (Object)metadataUuid).executeUpdate();
        this._entityManager.flush();
        this._entityManager.clear();
        return deleted;
    }

    @Override
    @Transactional
    public int deleteAllBySelectionAndUser(Integer selection, Integer userId) {
        String selectionIdPath = SortUtils.createPath(UserSavedSelection_.id, UserSavedSelectionId_.selectionId);
        String userIdPath = SortUtils.createPath(UserSavedSelection_.id, UserSavedSelectionId_.userId);
        String qlString = String.format("DELETE FROM UserSavedSelection WHERE %s = :selection AND %s = :userId", selectionIdPath, userIdPath);
        int deleted = this._entityManager.createQuery(qlString).setParameter("selection", (Object)selection).setParameter("userId", (Object)userId).executeUpdate();
        this._entityManager.flush();
        this._entityManager.clear();
        return deleted;
    }
}

