/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.mapservices;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import javax.annotation.Nonnull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MapService {
    private String url;
    private UrlType urlType = UrlType.TEXT;
    private Boolean useProxy = true;
    private AuthType authType;
    private String username;
    private String password;

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public void setUrl(String url) {
        this.url = url;
    }

    @Nonnull
    public String getUrlType() {
        return this.urlType.toString();
    }

    @Nonnull
    public void setUrlType(String urlType) {
        this.urlType = UrlType.valueOf(urlType);
    }

    @Nonnull
    public Boolean getUseProxy() {
        if (!this.authType.isPublicClientAllowed()) {
            return true;
        }
        return this.useProxy;
    }

    @Nonnull
    public void setUseProxy(boolean useProxy) {
        if (this.authType != null && !this.authType.isPublicClientAllowed() && !useProxy) {
            throw new IllegalArgumentException(String.format("Cannot set \"useProxy=false\". Authentication type %s only supports \"useProxy=true\" for security reasons. (%s)", new Object[]{this.authType, this}));
        }
        this.useProxy = useProxy;
    }

    @Nonnull
    public String getAuthType() {
        return this.authType.toString();
    }

    @Nonnull
    public void setAuthType(String authType) {
        if (authType != null && !AuthType.valueOf(authType).isPublicClientAllowed() && !this.useProxy.booleanValue()) {
            throw new IllegalArgumentException(String.format("Authentication type %s only supports \"useProxy=true\" for security reasons.(%s)", authType, this));
        }
        this.authType = AuthType.valueOf(authType);
    }

    @JsonIgnore
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "MapService{url='" + this.url + "', urlType=" + this.urlType + ", useProxy=" + this.useProxy + ", authType=" + this.authType + "}";
    }

    public static enum UrlType {
        TEXT,
        REGEXP;

    }

    public static enum AuthType {
        BEARER(true),
        BASIC(false);

        private boolean publicClientAllowed;

        private AuthType(boolean publicClientAllowed) {
            this.publicClientAllowed = publicClientAllowed;
        }

        public boolean isPublicClientAllowed() {
            return this.publicClientAllowed;
        }
    }
}

