/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.File;
import java.util.Comparator;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.SchematronRequirement;

@Entity
@Table(name="schematron", uniqueConstraints={@UniqueConstraint(columnNames={"schemaName", "filename"})})
@Cacheable
@Access(value=AccessType.PROPERTY)
@SequenceGenerator(name="schematron_id_seq", initialValue=100, allocationSize=1)
public class Schematron
extends Localized {
    public static final Comparator<? super Schematron> DISPLAY_PRIORITY_COMPARATOR = new Comparator<Schematron>(){

        @Override
        public int compare(Schematron o1, Schematron o2) {
            return Integer.compare(o1.getDisplayPriority(), o2.getDisplayPriority());
        }
    };
    static final String ID_SEQ_NAME = "schematron_id_seq";
    private static final int EXTENSION_LENGTH = ".xsl".length();
    private static final String SEPARATOR = File.separator;
    private static final String ALT_SEPARATOR = SEPARATOR.equals("\\") ? "/" : "\\";
    private int id;
    private String schemaName;
    private String file;
    private int displayPriority = 0;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="schematron_id_seq")
    @Column(nullable=false)
    public int getId() {
        return this.id;
    }

    public Schematron setId(int id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return "Schematron [_id=" + this.id + ", isoschema=" + this.schemaName + ", filename=" + this.file + ", description" + this.getLabelTranslations() + "]";
    }

    @Column(nullable=false, name="schemaName")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Column(nullable=false, name="filename")
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="SchematronDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false, length=255)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    public int getDisplayPriority() {
        return this.displayPriority;
    }

    public void setDisplayPriority(int displayPriority) {
        this.displayPriority = displayPriority;
    }

    @Transient
    public String getRuleName() {
        if (this.file == null) {
            return "unnamed rule";
        }
        int lastSegmentIndex = this.file.lastIndexOf(SEPARATOR);
        if (lastSegmentIndex < 0) {
            lastSegmentIndex = this.file.lastIndexOf(ALT_SEPARATOR);
        }
        lastSegmentIndex = lastSegmentIndex < 0 ? 0 : ++lastSegmentIndex;
        String rule = this.file.substring(lastSegmentIndex, this.file.length() - EXTENSION_LENGTH);
        String lowerCaseRuleName = rule.toLowerCase();
        for (SchematronRequirement requirement : SchematronRequirement.values()) {
            if (!lowerCaseRuleName.endsWith("." + requirement.name().toLowerCase())) continue;
            return rule.substring(0, rule.length() - requirement.name().length() - 1);
        }
        return rule;
    }

    @Transient
    public SchematronRequirement getDefaultRequirement() {
        String lowerCaseFile = this.getFile().toLowerCase();
        for (SchematronRequirement requirement : SchematronRequirement.values()) {
            if (!lowerCaseFile.endsWith("." + requirement.name().toLowerCase() + ".xsl")) continue;
            return requirement;
        }
        return SchematronRequirement.REQUIRED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schematron that = (Schematron)o;
        if (this.displayPriority != that.displayPriority) {
            return false;
        }
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        return !(this.schemaName != null ? !this.schemaName.equals(that.schemaName) : that.schemaName != null);
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + this.displayPriority;
        return result;
    }
}

