/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.entitylistener.MetadataValidationEntityListenerManager;
import org.hibernate.annotations.Type;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="Validation", indexes={@Index(name="idx_validation_metadataid", columnList="metadataid")})
@EntityListeners(value={MetadataValidationEntityListenerManager.class})
public class MetadataValidation
extends GeonetEntity {
    public static final String TABLE_NAME = "Validation";
    public static final String VALIDATION_DATE_COLUMN_NAME = "valDate";
    private MetadataValidationId id;
    private MetadataValidationStatus status;
    private int numTests = 0;
    private int numFailures = 0;
    private ISODate validationDate = new ISODate();
    private Boolean required = Boolean.TRUE;
    private String reportUrl;
    private String reportContent;

    @EmbeddedId
    public MetadataValidationId getId() {
        return this.id;
    }

    public MetadataValidation setId(MetadataValidationId id) {
        this.id = id;
        return this;
    }

    @Column(nullable=false)
    public MetadataValidationStatus getStatus() {
        return this.status;
    }

    public MetadataValidation setStatus(MetadataValidationStatus status) {
        this.status = status;
        return this;
    }

    @Transient
    public boolean isValid() {
        return this.getStatus() == MetadataValidationStatus.VALID;
    }

    public MetadataValidation setValid(boolean isValid) {
        this.setStatus(isValid ? MetadataValidationStatus.VALID : MetadataValidationStatus.INVALID);
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="valDate", length=30))
    public ISODate getValidationDate() {
        return this.validationDate;
    }

    public MetadataValidation setValidationDate(ISODate validationDate) {
        this.validationDate = validationDate;
        return this;
    }

    public MetadataValidation setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    @Column(nullable=true)
    @Nonnull
    public Boolean isRequired() {
        return this.required == null ? Boolean.TRUE : this.required;
    }

    @Column(name="tested")
    public int getNumTests() {
        return this.numTests;
    }

    public MetadataValidation setNumTests(int numTests) {
        this.numTests = numTests;
        return this;
    }

    @Column(name="failed")
    public int getNumFailures() {
        return this.numFailures;
    }

    public MetadataValidation setNumFailures(int numFailures) {
        this.numFailures = numFailures;
        return this;
    }

    @Column
    public String getReportUrl() {
        return this.reportUrl;
    }

    public MetadataValidation setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
        return this;
    }

    @Column
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    public String getReportContent() {
        return this.reportContent;
    }

    public MetadataValidation setReportContent(String reportContent) {
        this.reportContent = reportContent;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataValidation that = (MetadataValidation)o;
        return this.numTests == that.numTests && this.numFailures == that.numFailures && this.id.equals(that.id) && this.status == that.status && this.validationDate.equals(that.validationDate) && this.required.equals(that.required) && this.reportUrl.equals(that.reportUrl) && this.reportContent.equals(that.reportContent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.numTests, this.numFailures, this.validationDate, this.required, this.reportUrl, this.reportContent});
    }

    public String toString() {
        return "MetadataValidation{" + this.id + ", status=" + this.status + ", numTests=" + this.numTests + ", numFailures=" + this.numFailures + ", validationDate=" + this.validationDate + ", required=" + this.required + ", reportUrl=" + this.reportUrl + ", reportContent=" + this.reportContent + "}";
    }
}

