/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.username;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.nimbusds.jose.JWSObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geoserver.security.jwtheaders.JwtConfiguration;

public class JwtHeaderUserNameExtractor {
    JwtConfiguration jwtHeadersConfig;

    public JwtHeaderUserNameExtractor(JwtConfiguration config) {
        this.jwtHeadersConfig = config;
    }

    public static Object getClaim(Map<String, Object> map, String path) {
        return JwtHeaderUserNameExtractor.getClaim(map, new ArrayList<String>(Arrays.asList(path.split("\\."))));
    }

    private static Object getClaim(Map<String, Object> map, List<String> pathList) {
        if (map == null) {
            return null;
        }
        if (pathList.size() == 1) {
            return map.get(pathList.get(0));
        }
        String first = pathList.get(0);
        pathList.remove(0);
        return JwtHeaderUserNameExtractor.getClaim((Map<String, Object>)((Map)map.get(first)), pathList);
    }

    public static Object extractFromJSON(String json, String path) {
        try {
            return JsonPath.read((String)json, (String)path, (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String extractUserName(String userNameHeader) {
        if (userNameHeader == null) {
            return null;
        }
        if (this.jwtHeadersConfig.getUserNameFormatChoice() == JwtConfiguration.UserNameHeaderFormat.STRING) {
            String userName = userNameHeader.trim();
            if (userName.isBlank()) {
                return null;
            }
            return userName;
        }
        userNameHeader = userNameHeader.replaceFirst("^Bearer", "");
        userNameHeader = userNameHeader.replaceFirst("^bearer", "");
        userNameHeader = userNameHeader.trim();
        if (this.jwtHeadersConfig.getUserNameFormatChoice() == JwtConfiguration.UserNameHeaderFormat.JWT) {
            JWSObject jwsObject = null;
            try {
                jwsObject = JWSObject.parse((String)userNameHeader);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            Map claims = jwsObject.getPayload().toJSONObject();
            String userName = (String)JwtHeaderUserNameExtractor.getClaim((Map<String, Object>)claims, this.jwtHeadersConfig.getUserNameJsonPath());
            return userName;
        }
        if (this.jwtHeadersConfig.getUserNameFormatChoice() == JwtConfiguration.UserNameHeaderFormat.JSON) {
            return (String)JwtHeaderUserNameExtractor.extractFromJSON(userNameHeader, this.jwtHeadersConfig.getUserNameJsonPath());
        }
        return null;
    }
}

