/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.instrumentation;

import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.http.TransportHttpClient;
import co.elastic.clients.transport.instrumentation.Instrumentation;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenTelemetryForElasticsearch
implements Instrumentation {
    private static final Set<String> SEARCH_ENDPOINTS = new HashSet<String>(Arrays.asList("render_search_template", "terms_enum", "msearch_template", "eql.search", "msearch", "search_template", "async_search.submit", "search"));
    private static final AttributeKey<String> ATTR_DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
    private static final AttributeKey<String> ATTR_DB_OPERATION = AttributeKey.stringKey((String)"db.operation");
    private static final AttributeKey<String> ATTR_DB_STATEMENT = AttributeKey.stringKey((String)"db.statement");
    private static final AttributeKey<String> ATTR_HTTP_REQUEST_METHOD = AttributeKey.stringKey((String)"http.request.method");
    private static final AttributeKey<String> ATTR_URL_FULL = AttributeKey.stringKey((String)"url.full");
    private static final AttributeKey<String> ATTR_SERVER_ADDRESS = AttributeKey.stringKey((String)"server.address");
    private static final AttributeKey<Long> ATTR_SERVER_PORT = AttributeKey.longKey((String)"server.port");
    private static final Map<String, AttributeKey<String>> attributesKeyCache = new ConcurrentHashMap<String, AttributeKey<String>>();
    private static final String PATH_PART_PREFIX = "db.elasticsearch.path_parts.";
    private static final boolean INSTRUMENTATION_ENABLED = Boolean.parseBoolean(ConfigUtil.access$000("otel.instrumentation.elasticsearch.enabled", "true"));
    private static final boolean CAPTURE_SEARCH_BODY = Boolean.parseBoolean(ConfigUtil.access$000("otel.instrumentation.elasticsearch.capture-search-query", "false"));
    private static final Log logger = LogFactory.getLog(OpenTelemetryForElasticsearch.class);
    private final Tracer tracer;
    private final boolean captureSearchBody;

    @Nullable
    public static OpenTelemetryForElasticsearch getDefault() {
        boolean enabled = Boolean.parseBoolean(ConfigUtil.getConfigOption("otel.instrumentation.elasticsearch.enabled", "true"));
        if (!enabled) {
            return null;
        }
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        if (openTelemetry == OpenTelemetry.noop()) {
            return null;
        }
        boolean captureSearchBody = Boolean.parseBoolean(ConfigUtil.getConfigOption("otel.instrumentation.elasticsearch.capture-search-query", "false"));
        return new OpenTelemetryForElasticsearch(openTelemetry, captureSearchBody);
    }

    public OpenTelemetryForElasticsearch(OpenTelemetry openTelemetry, boolean captureSearchBody) {
        Version version = Version.VERSION;
        this.tracer = openTelemetry.tracerBuilder("elasticsearch-api").setInstrumentationVersion(version == null ? "unknown" : version.toString()).setSchemaUrl("https://opentelemetry.io/schemas/1.21.0").build();
        this.captureSearchBody = captureSearchBody;
    }

    @Override
    public <TRequest> Instrumentation.Context newContext(TRequest request, Endpoint<TRequest, ?, ?> endpoint) {
        return new OTelContext(request, endpoint);
    }

    private boolean shouldCaptureBody(Span span, String endpointId) {
        return this.captureSearchBody && span.isRecording() && SEARCH_ENDPOINTS.contains(endpointId);
    }

    private String pathAndQuery(TransportHttpClient.Request request, TransportOptions options) {
        Map<Object, Object> allParams;
        Map<Object, Object> optionsParams;
        String path = request.path();
        path = path.length() > 0 && path.charAt(0) == '/' ? path.substring(1) : path;
        Map<String, String> requestParams = request.queryParams();
        Map<Object, Object> map = optionsParams = options == null ? Collections.emptyMap() : options.queryParameters();
        if (requestParams.isEmpty()) {
            allParams = optionsParams;
        } else if (optionsParams.isEmpty()) {
            allParams = requestParams;
        } else {
            allParams = new HashMap<String, String>(requestParams);
            allParams.putAll(optionsParams);
        }
        if (allParams.isEmpty()) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path);
        int sep = 63;
        for (Map.Entry<Object, Object> e : allParams.entrySet()) {
            sb.append((char)sep);
            sep = 38;
            try {
                sb.append(URLEncoder.encode((String)e.getKey(), "UTF-8"));
                sb.append('=');
                sb.append(URLEncoder.encode((String)e.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return sb.toString();
    }

    private static final class ConfigUtil {
        private ConfigUtil() {
        }

        private static String getConfigOption(String key, String defaultValue) {
            String normalizedKey = ConfigUtil.normalizePropertyKey(key);
            String systemProperty = System.getProperties().entrySet().stream().filter(entry -> normalizedKey.equals(ConfigUtil.normalizePropertyKey(entry.getKey().toString()))).map(entry -> entry.getValue().toString()).findFirst().orElse(null);
            if (systemProperty != null) {
                return systemProperty;
            }
            return System.getenv().entrySet().stream().filter(entry -> normalizedKey.equals(ConfigUtil.normalizeEnvironmentVariableKey((String)entry.getKey()))).map(Map.Entry::getValue).findFirst().orElse(defaultValue);
        }

        private static String normalizeEnvironmentVariableKey(String key) {
            return key.toLowerCase(Locale.ROOT).replace("_", ".");
        }

        private static String normalizePropertyKey(String key) {
            return key.toLowerCase(Locale.ROOT).replace("-", ".");
        }
    }

    class OTelContext
    implements Instrumentation.Context {
        private final Span span;
        private String endpointId;
        private String pathAndQuery = null;

        <TRequest> OTelContext(TRequest request, Endpoint<TRequest, ?, ?> endpoint) {
            Span span;
            try {
                String endpointId = endpoint.id();
                if (endpointId.startsWith("es/")) {
                    endpointId = endpointId.substring(3);
                }
                this.endpointId = endpointId;
                span = OpenTelemetryForElasticsearch.this.tracer.spanBuilder(endpointId).setSpanKind(SpanKind.CLIENT).startSpan();
                if (span.isRecording()) {
                    span.setAttribute(ATTR_DB_SYSTEM, (Object)"elasticsearch");
                    span.setAttribute(ATTR_DB_OPERATION, (Object)endpointId);
                    span.setAttribute(ATTR_HTTP_REQUEST_METHOD, (Object)endpoint.method(request));
                    for (Map.Entry<String, String> pathParamEntry : endpoint.pathParameters(request).entrySet()) {
                        AttributeKey attributeKey = attributesKeyCache.computeIfAbsent(pathParamEntry.getKey(), key -> AttributeKey.stringKey((String)(OpenTelemetryForElasticsearch.PATH_PART_PREFIX + key)));
                        span.setAttribute(attributeKey, (Object)pathParamEntry.getValue());
                    }
                }
            }
            catch (RuntimeException e) {
                logger.debug((Object)("Failed creating an OpenTelemetry span for endpoint '" + endpoint.id() + "'."), (Throwable)e);
                span = Span.getInvalid();
            }
            this.span = span;
        }

        @Override
        public void beforeSendingHttpRequest(TransportHttpClient.Request httpRequest, TransportOptions options) {
            try {
                this.pathAndQuery = OpenTelemetryForElasticsearch.this.pathAndQuery(httpRequest, options);
                this.span.setAttribute(ATTR_HTTP_REQUEST_METHOD, (Object)httpRequest.method());
                Iterable<ByteBuffer> body = httpRequest.body();
                if (body != null && OpenTelemetryForElasticsearch.this.shouldCaptureBody(this.span, this.endpointId)) {
                    StringBuilder sb = new StringBuilder();
                    for (ByteBuffer buf : body) {
                        buf.mark();
                        sb.append(StandardCharsets.UTF_8.decode(buf));
                        buf.reset();
                    }
                    this.span.setAttribute(ATTR_DB_STATEMENT, (Object)sb.toString());
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Failed reading HTTP body content for an OpenTelemetry span.", (Throwable)e);
            }
        }

        @Override
        public void afterReceivingHttpResponse(TransportHttpClient.Response httpResponse) {
            try {
                if (this.span.isRecording()) {
                    URI uri = httpResponse.node().uri();
                    String fullUrl = uri.resolve(this.pathAndQuery).toString();
                    this.span.setAttribute(ATTR_URL_FULL, (Object)fullUrl);
                    this.span.setAttribute(ATTR_SERVER_PORT, uri.getPort());
                    this.span.setAttribute(ATTR_SERVER_ADDRESS, (Object)uri.getHost());
                }
            }
            catch (RuntimeException e) {
                logger.debug((Object)"Failed capturing response information for the OpenTelemetry span.", (Throwable)e);
            }
        }

        @Override
        public <TResponse> void afterDecodingApiResponse(TResponse apiResponse) {
        }

        @Override
        public void recordException(Throwable throwable) {
            this.span.setStatus(StatusCode.ERROR, throwable.getMessage());
            this.span.recordException(throwable);
        }

        @Override
        public void close() {
            this.span.end();
        }

        @Override
        public Instrumentation.ThreadScope makeCurrent() {
            return new OTelScope(this.span);
        }
    }

    class OTelScope
    implements Instrumentation.ThreadScope {
        private final Scope scope;

        OTelScope(Span span) {
            this.scope = span.makeCurrent();
        }

        @Override
        public void close() {
            this.scope.close();
        }
    }
}

