/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class S3RepositorySettings
extends RepositorySettingsBase {
    private final String bucket;
    @Nullable
    private final String client;
    @Nullable
    private final String basePath;
    @Nullable
    private final Boolean readonly;
    @Nullable
    private final Boolean serverSideEncryption;
    @Nullable
    private final String bufferSize;
    @Nullable
    private final String cannedAcl;
    @Nullable
    private final String storageClass;
    public static final JsonpDeserializer<S3RepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, S3RepositorySettings::setupS3RepositorySettingsDeserializer);

    private S3RepositorySettings(Builder builder) {
        super(builder);
        this.bucket = ApiTypeHelper.requireNonNull(builder.bucket, this, "bucket");
        this.client = builder.client;
        this.basePath = builder.basePath;
        this.readonly = builder.readonly;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.bufferSize = builder.bufferSize;
        this.cannedAcl = builder.cannedAcl;
        this.storageClass = builder.storageClass;
    }

    public static S3RepositorySettings of(Function<Builder, ObjectBuilder<S3RepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String bucket() {
        return this.bucket;
    }

    @Nullable
    public final String client() {
        return this.client;
    }

    @Nullable
    public final String basePath() {
        return this.basePath;
    }

    @Nullable
    public final Boolean readonly() {
        return this.readonly;
    }

    @Nullable
    public final Boolean serverSideEncryption() {
        return this.serverSideEncryption;
    }

    @Nullable
    public final String bufferSize() {
        return this.bufferSize;
    }

    @Nullable
    public final String cannedAcl() {
        return this.cannedAcl;
    }

    @Nullable
    public final String storageClass() {
        return this.storageClass;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("bucket");
        generator.write(this.bucket);
        if (this.client != null) {
            generator.writeKey("client");
            generator.write(this.client);
        }
        if (this.basePath != null) {
            generator.writeKey("base_path");
            generator.write(this.basePath);
        }
        if (this.readonly != null) {
            generator.writeKey("readonly");
            generator.write(this.readonly.booleanValue());
        }
        if (this.serverSideEncryption != null) {
            generator.writeKey("server_side_encryption");
            generator.write(this.serverSideEncryption.booleanValue());
        }
        if (this.bufferSize != null) {
            generator.writeKey("buffer_size");
            generator.write(this.bufferSize);
        }
        if (this.cannedAcl != null) {
            generator.writeKey("canned_acl");
            generator.write(this.cannedAcl);
        }
        if (this.storageClass != null) {
            generator.writeKey("storage_class");
            generator.write(this.storageClass);
        }
    }

    protected static void setupS3RepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::bucket, JsonpDeserializer.stringDeserializer(), "bucket");
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client");
        op.add(Builder::basePath, JsonpDeserializer.stringDeserializer(), "base_path");
        op.add(Builder::readonly, JsonpDeserializer.booleanDeserializer(), "readonly");
        op.add(Builder::serverSideEncryption, JsonpDeserializer.booleanDeserializer(), "server_side_encryption");
        op.add(Builder::bufferSize, JsonpDeserializer.stringDeserializer(), "buffer_size");
        op.add(Builder::cannedAcl, JsonpDeserializer.stringDeserializer(), "canned_acl");
        op.add(Builder::storageClass, JsonpDeserializer.stringDeserializer(), "storage_class");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<S3RepositorySettings> {
        private String bucket;
        @Nullable
        private String client;
        @Nullable
        private String basePath;
        @Nullable
        private Boolean readonly;
        @Nullable
        private Boolean serverSideEncryption;
        @Nullable
        private String bufferSize;
        @Nullable
        private String cannedAcl;
        @Nullable
        private String storageClass;

        public final Builder bucket(String value) {
            this.bucket = value;
            return this;
        }

        public final Builder client(@Nullable String value) {
            this.client = value;
            return this;
        }

        public final Builder basePath(@Nullable String value) {
            this.basePath = value;
            return this;
        }

        public final Builder readonly(@Nullable Boolean value) {
            this.readonly = value;
            return this;
        }

        public final Builder serverSideEncryption(@Nullable Boolean value) {
            this.serverSideEncryption = value;
            return this;
        }

        public final Builder bufferSize(@Nullable String value) {
            this.bufferSize = value;
            return this;
        }

        public final Builder cannedAcl(@Nullable String value) {
            this.cannedAcl = value;
            return this;
        }

        public final Builder storageClass(@Nullable String value) {
            this.storageClass = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public S3RepositorySettings build() {
            this._checkSingleUse();
            return new S3RepositorySettings(this);
        }
    }
}

