/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.security.RoleDescriptor;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ApiKey
implements JsonpSerializable {
    @Nullable
    private final Long creation;
    @Nullable
    private final Long expiration;
    private final String id;
    @Nullable
    private final Boolean invalidated;
    private final String name;
    @Nullable
    private final String realm;
    @Nullable
    private final String realmType;
    @Nullable
    private final String username;
    @Nullable
    private final String profileUid;
    private final Map<String, JsonData> metadata;
    private final Map<String, RoleDescriptor> roleDescriptors;
    private final List<Map<String, RoleDescriptor>> limitedBy;
    private final List<FieldValue> sort;
    public static final JsonpDeserializer<ApiKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApiKey::setupApiKeyDeserializer);

    private ApiKey(Builder builder) {
        this.creation = builder.creation;
        this.expiration = builder.expiration;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.invalidated = builder.invalidated;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.realm = builder.realm;
        this.realmType = builder.realmType;
        this.username = builder.username;
        this.profileUid = builder.profileUid;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.roleDescriptors = ApiTypeHelper.unmodifiable(builder.roleDescriptors);
        this.limitedBy = ApiTypeHelper.unmodifiable(builder.limitedBy);
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
    }

    public static ApiKey of(Function<Builder, ObjectBuilder<ApiKey>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long creation() {
        return this.creation;
    }

    @Nullable
    public final Long expiration() {
        return this.expiration;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Boolean invalidated() {
        return this.invalidated;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String realm() {
        return this.realm;
    }

    @Nullable
    public final String realmType() {
        return this.realmType;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Nullable
    public final String profileUid() {
        return this.profileUid;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final Map<String, RoleDescriptor> roleDescriptors() {
        return this.roleDescriptors;
    }

    public final List<Map<String, RoleDescriptor>> limitedBy() {
        return this.limitedBy;
    }

    public final List<FieldValue> sort() {
        return this.sort;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.creation != null) {
            generator.writeKey("creation");
            generator.write(this.creation.longValue());
        }
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration.longValue());
        }
        generator.writeKey("id");
        generator.write(this.id);
        if (this.invalidated != null) {
            generator.writeKey("invalidated");
            generator.write(this.invalidated.booleanValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.realm != null) {
            generator.writeKey("realm");
            generator.write(this.realm);
        }
        if (this.realmType != null) {
            generator.writeKey("realm_type");
            generator.write(this.realmType);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
        if (this.profileUid != null) {
            generator.writeKey("profile_uid");
            generator.write(this.profileUid);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roleDescriptors)) {
            generator.writeKey("role_descriptors");
            generator.writeStartObject();
            for (Map.Entry entry : this.roleDescriptors.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RoleDescriptor)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.limitedBy)) {
            generator.writeKey("limited_by");
            generator.writeStartArray();
            for (Map map : this.limitedBy) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((RoleDescriptor)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("_sort");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.sort) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupApiKeyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::creation, JsonpDeserializer.longDeserializer(), "creation");
        op.add(Builder::expiration, JsonpDeserializer.longDeserializer(), "expiration");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::invalidated, JsonpDeserializer.booleanDeserializer(), "invalidated");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
        op.add(Builder::realmType, JsonpDeserializer.stringDeserializer(), "realm_type");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::profileUid, JsonpDeserializer.stringDeserializer(), "profile_uid");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::roleDescriptors, JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER), "role_descriptors");
        op.add(Builder::limitedBy, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER)), "limited_by");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "_sort");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ApiKey> {
        @Nullable
        private Long creation;
        @Nullable
        private Long expiration;
        private String id;
        @Nullable
        private Boolean invalidated;
        private String name;
        @Nullable
        private String realm;
        @Nullable
        private String realmType;
        @Nullable
        private String username;
        @Nullable
        private String profileUid;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Map<String, RoleDescriptor> roleDescriptors;
        @Nullable
        private List<Map<String, RoleDescriptor>> limitedBy;
        @Nullable
        private List<FieldValue> sort;

        public final Builder creation(@Nullable Long value) {
            this.creation = value;
            return this;
        }

        public final Builder expiration(@Nullable Long value) {
            this.expiration = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder invalidated(@Nullable Boolean value) {
            this.invalidated = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder realm(@Nullable String value) {
            this.realm = value;
            return this;
        }

        public final Builder realmType(@Nullable String value) {
            this.realmType = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        public final Builder profileUid(@Nullable String value) {
            this.profileUid = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder roleDescriptors(Map<String, RoleDescriptor> map) {
            this.roleDescriptors = Builder._mapPutAll(this.roleDescriptors, map);
            return this;
        }

        public final Builder roleDescriptors(String key, RoleDescriptor value) {
            this.roleDescriptors = Builder._mapPut(this.roleDescriptors, key, value);
            return this;
        }

        public final Builder roleDescriptors(String key, Function<RoleDescriptor.Builder, ObjectBuilder<RoleDescriptor>> fn) {
            return this.roleDescriptors(key, fn.apply(new RoleDescriptor.Builder()).build());
        }

        public final Builder limitedBy(List<Map<String, RoleDescriptor>> list) {
            this.limitedBy = Builder._listAddAll(this.limitedBy, list);
            return this;
        }

        public final Builder limitedBy(Map<String, RoleDescriptor> value, Map<String, RoleDescriptor> ... values) {
            this.limitedBy = Builder._listAdd(this.limitedBy, value, values);
            return this;
        }

        public final Builder sort(List<FieldValue> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(FieldValue value, FieldValue ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (String v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(long value, long ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (long v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(double value, double ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (double v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(boolean value, boolean ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (boolean v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.sort(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ApiKey build() {
            this._checkSingleUse();
            return new ApiKey(this);
        }
    }
}

