/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_ruleset;

import co.elastic.clients.elasticsearch.query_ruleset.QueryRuleCriteriaType;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRuleCriteria
implements JsonpSerializable {
    private final QueryRuleCriteriaType type;
    private final String metadata;
    private final List<JsonData> values;
    public static final JsonpDeserializer<QueryRuleCriteria> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRuleCriteria::setupQueryRuleCriteriaDeserializer);

    private QueryRuleCriteria(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.metadata = ApiTypeHelper.requireNonNull(builder.metadata, this, "metadata");
        this.values = ApiTypeHelper.unmodifiable(builder.values);
    }

    public static QueryRuleCriteria of(Function<Builder, ObjectBuilder<QueryRuleCriteria>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final QueryRuleCriteriaType type() {
        return this.type;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final List<JsonData> values() {
        return this.values;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("metadata");
        generator.write(this.metadata);
        if (ApiTypeHelper.isDefined(this.values)) {
            generator.writeKey("values");
            generator.writeStartArray();
            for (JsonData item0 : this.values) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryRuleCriteriaDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, QueryRuleCriteriaType._DESERIALIZER, "type");
        op.add(Builder::metadata, JsonpDeserializer.stringDeserializer(), "metadata");
        op.add(Builder::values, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "values");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryRuleCriteria> {
        private QueryRuleCriteriaType type;
        private String metadata;
        @Nullable
        private List<JsonData> values;

        public final Builder type(QueryRuleCriteriaType value) {
            this.type = value;
            return this;
        }

        public final Builder metadata(String value) {
            this.metadata = value;
            return this;
        }

        public final Builder values(List<JsonData> list) {
            this.values = Builder._listAddAll(this.values, list);
            return this;
        }

        public final Builder values(JsonData value, JsonData ... values) {
            this.values = Builder._listAdd(this.values, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRuleCriteria build() {
            this._checkSingleUse();
            return new QueryRuleCriteria(this);
        }
    }
}

