/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.GeoShapeRelation;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EnrichProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Integer maxMatches;
    @Nullable
    private final Boolean override;
    private final String policyName;
    @Nullable
    private final GeoShapeRelation shapeRelation;
    private final String targetField;
    public static final JsonpDeserializer<EnrichProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrichProcessor::setupEnrichProcessorDeserializer);

    private EnrichProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.maxMatches = builder.maxMatches;
        this.override = builder.override;
        this.policyName = ApiTypeHelper.requireNonNull(builder.policyName, this, "policyName");
        this.shapeRelation = builder.shapeRelation;
        this.targetField = ApiTypeHelper.requireNonNull(builder.targetField, this, "targetField");
    }

    public static EnrichProcessor of(Function<Builder, ObjectBuilder<EnrichProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Enrich;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final Integer maxMatches() {
        return this.maxMatches;
    }

    @Nullable
    public final Boolean override() {
        return this.override;
    }

    public final String policyName() {
        return this.policyName;
    }

    @Nullable
    public final GeoShapeRelation shapeRelation() {
        return this.shapeRelation;
    }

    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.maxMatches != null) {
            generator.writeKey("max_matches");
            generator.write(this.maxMatches.intValue());
        }
        if (this.override != null) {
            generator.writeKey("override");
            generator.write(this.override.booleanValue());
        }
        generator.writeKey("policy_name");
        generator.write(this.policyName);
        if (this.shapeRelation != null) {
            generator.writeKey("shape_relation");
            this.shapeRelation.serialize(generator, mapper);
        }
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupEnrichProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::maxMatches, JsonpDeserializer.integerDeserializer(), "max_matches");
        op.add(Builder::override, JsonpDeserializer.booleanDeserializer(), "override");
        op.add(Builder::policyName, JsonpDeserializer.stringDeserializer(), "policy_name");
        op.add(Builder::shapeRelation, GeoShapeRelation._DESERIALIZER, "shape_relation");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EnrichProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Integer maxMatches;
        @Nullable
        private Boolean override;
        private String policyName;
        @Nullable
        private GeoShapeRelation shapeRelation;
        private String targetField;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder maxMatches(@Nullable Integer value) {
            this.maxMatches = value;
            return this;
        }

        public final Builder override(@Nullable Boolean value) {
            this.override = value;
            return this;
        }

        public final Builder policyName(String value) {
            this.policyName = value;
            return this;
        }

        public final Builder shapeRelation(@Nullable GeoShapeRelation value) {
            this.shapeRelation = value;
            return this;
        }

        public final Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EnrichProcessor build() {
            this._checkSingleUse();
            return new EnrichProcessor(this);
        }
    }
}

