/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import it.geosolutions.rendered.viewer.DisplayHistogram;
import it.geosolutions.rendered.viewer.HTMLBuilder;
import it.geosolutions.rendered.viewer.ImageViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class RenderedImageInfoPanel
extends JPanel {
    private static final Map<Integer, String> TYPE_MAP = new HashMap<Integer, String>();
    private static final Map<Object, String> KEY_MAP = new HashMap<Object, String>();
    private static final Logger logger = Logger.getLogger(RenderedImageInfoPanel.class.toString());
    JTabbedPane tabs;
    JEditorPane generalPanel;
    JEditorPane propertiesPanel;
    private JEditorPane operationPanel;
    ImageViewer viewer;
    private ImageViewer roiViewer;
    private boolean showHistogram = true;
    private DisplayHistogram histogramPanel = new DisplayHistogram("");
    private boolean showRoi;

    public RenderedImageInfoPanel() {
        this(false, false);
    }

    public RenderedImageInfoPanel(boolean showHistogram) {
        this(showHistogram, false);
    }

    public RenderedImageInfoPanel(boolean showHistogram, boolean showRoi) {
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.add((Component)this.tabs, "Center");
        this.showHistogram = showHistogram;
        this.showRoi = showRoi;
        this.generalPanel = this.buildHtmlPane();
        this.propertiesPanel = this.buildHtmlPane();
        this.operationPanel = this.buildHtmlPane();
        if (showRoi) {
            this.roiViewer = new ImageViewer();
            this.viewer = new ImageViewer(this.roiViewer);
            this.roiViewer.setRelatedViewer(this.viewer);
        } else {
            this.viewer = new ImageViewer();
        }
        this.tabs.addTab("General information", this.scroll(this.generalPanel));
        this.tabs.addTab("Viewer", this.viewer);
        this.tabs.addTab("Properties", this.scroll(this.propertiesPanel));
        this.tabs.addTab("Operation", this.scroll(this.operationPanel));
        if (showHistogram) {
            this.tabs.addTab("Histogram", this.scroll(this.histogramPanel));
        }
        if (showRoi) {
            this.tabs.addTab("ROIViewer", this.roiViewer);
        }
    }

    private JScrollPane scroll(JComponent pane) {
        return new JScrollPane(pane);
    }

    private JEditorPane buildHtmlPane() {
        ScrollTopEditorPane pane = new ScrollTopEditorPane("text/html", "");
        pane.setEditable(false);
        return pane;
    }

    public void setImage(RenderedImage image) {
        this.buildGeneralInfoPane(image);
        this.buildPropertiesPane(image);
        if (image instanceof RenderedOp) {
            this.operationPanel.setEnabled(true);
            this.buildOpPane((RenderedOp)image);
        } else {
            this.operationPanel.setText("This image is not an operation");
        }
        if (this.showHistogram) {
            this.histogramPanel.setImage(PlanarImage.wrapRenderedImage((RenderedImage)image));
        }
        try {
            this.viewer.setImage(image);
        }
        catch (Exception e) {
            this.viewer.setImage(null);
            this.viewer.setStatusMessage("Error:" + e.getMessage());
            e.printStackTrace();
        }
        if (this.showRoi) {
            try {
                if (image instanceof RenderedOp) {
                    Object object = image.getProperty("ROI");
                    if (object instanceof ROI) {
                        ROI roi = (ROI)object;
                        this.roiViewer.setImage((RenderedImage)roi.getAsImage());
                    } else {
                        this.roiViewer.setImage(null);
                    }
                } else {
                    this.roiViewer.setImage(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.roiViewer.setImage(null);
                this.roiViewer.setStatusMessage("Error:" + e.getMessage());
            }
        }
    }

    void buildOpPane(RenderedOp image) {
        String renderingName;
        HTMLBuilder hb;
        block6: {
            hb = new HTMLBuilder();
            hb.title("Operation");
            renderingName = "null";
            try {
                image.getWidth();
                renderingName = image.getCurrentRendering().getClass().getName();
            }
            catch (Exception ignored) {
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, ignored.getMessage());
            }
        }
        hb.dataLine("Name", image.getOperationName() + " (" + renderingName + ')');
        hb.title("Parameters");
        ParameterBlock block = image.getParameterBlock();
        Vector<Object> paramValues = block.getParameters();
        for (int i = 0; i < paramValues.size(); ++i) {
            String name = "Parameter " + (i + 1);
            if (block instanceof ParameterBlockJAI) {
                name = ((ParameterBlockJAI)block).getParameterListDescriptor().getParamNames()[i];
            }
            hb.dataLine(name, paramValues.get(i));
        }
        hb.title("Hints");
        RenderingHints hints = image.getRenderingHints();
        ArrayList<Object> keys = new ArrayList<Object>(hints.keySet());
        for (Object e : keys) {
            String label = KEY_MAP.get(e);
            if (label == null) {
                label = e.toString();
            }
            hb.dataLine(label, hints.get(e));
        }
        this.operationPanel.setText(hb.getHtml());
    }

    void buildPropertiesPane(RenderedImage source) {
        HTMLBuilder hb = new HTMLBuilder();
        hb.title("Properties");
        Object[] properties = source.getPropertyNames();
        if (properties == null) {
            this.propertiesPanel.setText("No properties found in this image");
            return;
        }
        Arrays.sort(properties);
        for (Object propName : properties) {
            hb.dataLine((String)propName, source.getProperty((String)propName));
        }
        this.propertiesPanel.setText(hb.getHtml());
        this.operationPanel.setCaretPosition(0);
    }

    void buildGeneralInfoPane(RenderedImage image) {
        HTMLBuilder hb = new HTMLBuilder();
        hb.title("Abstract");
        hb.dataLine("Name", this.getImageName(image));
        hb.dataLine("Image class", image.getClass());
        hb.dataLine("Image origin", image.getMinX() + " , " + image.getMinY());
        hb.dataLine("Image size", image.getWidth() + " x " + image.getHeight());
        hb.dataLine("[Debug_IDHash]:", Integer.toHexString(System.identityHashCode(image)));
        hb.title("Tiles organisation");
        int tw = image.getTileWidth();
        int th = image.getTileHeight();
        int ytc = image.getNumYTiles();
        int xtc = image.getNumXTiles();
        hb.dataLine("Tile size", tw + " x " + th);
        hb.dataLine("Tile grid", xtc + " x " + ytc + " (" + tw * xtc + " x " + th * ytc + ')');
        hb.dataLine("Tile offsets x,y", image.getTileGridXOffset() + ", " + image.getTileGridYOffset());
        hb.dataLine("Min tile x,y", image.getMinTileX() + ", " + image.getMinTileY());
        hb.title("Sample model");
        SampleModel sm = image.getSampleModel();
        hb.dataLine("Sample model", sm.getClass());
        hb.dataLine("Size", sm.getWidth() + " x " + sm.getHeight());
        hb.dataLine("Bands", sm.getNumBands());
        hb.dataLine("Bands datatype", TYPE_MAP.get(sm.getDataType()));
        if (sm instanceof ComponentSampleModel) {
            int[] sampleSizes;
            int[] bIndices;
            int[] bOffsets;
            ComponentSampleModel csm = (ComponentSampleModel)sm;
            StringBuilder sb = new StringBuilder();
            for (int bOffset : bOffsets = csm.getBandOffsets()) {
                sb.append(bOffset + ",");
            }
            sb.setLength(sb.length() - 1);
            hb.dataLine("BandOffsets", sb.toString());
            sb.setLength(0);
            for (int bIndex : bIndices = csm.getBankIndices()) {
                sb.append(bIndex + ",");
            }
            sb.setLength(sb.length() - 1);
            hb.dataLine("BandIndices", sb.toString());
            hb.dataLine("PixelStride", csm.getPixelStride());
            hb.dataLine("ScanlineStride", csm.getScanlineStride());
            sb.setLength(0);
            for (int sampleSize : sampleSizes = csm.getSampleSize()) {
                sb.append(sampleSize + ",");
            }
            sb.setLength(sb.length() - 1);
            hb.dataLine("SampleSize", sb.toString());
        }
        hb.title("Color model");
        ColorModel colorModel = image.getColorModel();
        if (colorModel != null) {
            hb.dataLine("Color model", colorModel.getClass());
            switch (colorModel.getTransparency()) {
                case 1: {
                    hb.dataLine("Transparency", "Opaque");
                    break;
                }
                case 3: {
                    hb.dataLine("Transparency", "Translucent");
                    break;
                }
                case 2: {
                    hb.dataLine("Transparency", "Bitmask");
                }
            }
            if (colorModel instanceof IndexColorModel) {
                String colormapHeader;
                IndexColorModel icm = (IndexColorModel)colorModel;
                hb.dataLine("Transparent Pixel", Integer.toString(icm.getTransparentPixel()));
                int colorMapSize = icm.getMapSize();
                hb.dataLine("ColorMap Size", Integer.toString(colorMapSize));
                int numbands = icm.hasAlpha() ? 4 : 3;
                byte[][] cmap = new byte[numbands][icm.getMapSize()];
                icm.getReds(cmap[0]);
                icm.getGreens(cmap[1]);
                icm.getBlues(cmap[2]);
                if (numbands == 4) {
                    icm.getAlphas(cmap[3]);
                }
                StringBuilder b = new StringBuilder();
                boolean truncated = false;
                if (colorMapSize > 255) {
                    colorMapSize = 255;
                    truncated = true;
                }
                for (int i = 0; i < colorMapSize; ++i) {
                    b.append('(').append(i).append(")-").append('[').append(cmap[0][i]).append(',').append(cmap[1][i]).append(',').append(cmap[2][i]);
                    if (numbands == 4) {
                        b.append(',').append(cmap[3][i]);
                    }
                    b.append(']').append('\n');
                }
                String string = colormapHeader = truncated ? "Truncated ColorMap" : "ColorMap";
                if (truncated) {
                    b.append(".... ColorMap was too long. Truncated to 255 Colors");
                }
                hb.dataLine(colormapHeader, b.toString());
            }
            hb.dataLine("Color space", colorModel.getColorSpace().getClass());
        }
        hb.title("Sources");
        Vector<RenderedImage> sources = image.getSources();
        int size = sources != null && !sources.isEmpty() ? sources.size() : 0;
        for (int i = 0; i < size; ++i) {
            hb.dataLine("Source " + (i + 1), this.getImageName((RenderedImage)sources.get(i)));
        }
        this.generalPanel.setText(hb.getHtml());
    }

    private String getImageName(RenderedImage source) {
        if (source instanceof RenderedOp) {
            return "RenderedOp, <i>" + ((RenderedOp)source).getOperationName() + "</i>";
        }
        return "Generic <i>" + source.getClass() + "</i>";
    }

    static {
        TYPE_MAP.put(0, "Byte");
        TYPE_MAP.put(5, "Double");
        TYPE_MAP.put(4, "Float");
        TYPE_MAP.put(3, "Int");
        TYPE_MAP.put(2, "Short");
        TYPE_MAP.put(32, "Undefined");
        TYPE_MAP.put(1, "Short");
        try {
            Field[] fields;
            for (Field field : fields = JAI.class.getFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !field.getName().startsWith("KEY_")) continue;
                KEY_MAP.put(field.get(null), field.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ScrollTopEditorPane
    extends JEditorPane {
        public ScrollTopEditorPane(String type, String text) {
            super(type, text);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            this.setCaretPosition(0);
        }
    }
}

