/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.colorindexer.ColorIndexerCRIF;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;

public class ColorIndexerDescriptor
extends OperationDescriptorImpl {
    static final Logger LOGGER = Logger.getLogger(ColorIndexerCRIF.class.toString());
    private static final long serialVersionUID = 4951347100540806326L;
    public static final String OPERATION_NAME = "ColorIndexer";

    public ColorIndexerDescriptor() {
        super((String[][])new String[][]{{"GlobalName", OPERATION_NAME}, {"LocalName", OPERATION_NAME}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Produce a paletted image from an RGB or RGBA image using a provided palette."}, {"DocURL", "http://www.geo-solutions.it/"}, {"Version", "1.0"}, {"arg0Desc", "Indexer."}, {"arg1Desc", "ROI."}, {"arg2Desc", "NoData."}, {"arg3Desc", "DestinationNoData."}}, new String[]{"rendered"}, 1, new String[]{"Indexer", "roi", "nodata", "destNoData"}, new Class[]{ColorIndexer.class, ROI.class, Range.class, Integer.class}, new Object[]{null, null, null, 0}, null);
    }

    protected boolean validateSources(String modeName, ParameterBlock param, StringBuffer message) {
        if (super.validateSources(modeName, param, message)) {
            int i = param.getNumSources();
            while (--i >= 0) {
                Object source = param.getSource(i);
                if (source instanceof RenderedImage) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
        if (!super.validateParameters(modeName, param, message)) {
            return false;
        }
        return param.getObjectParameter(0) instanceof ColorIndexer;
    }

    public static RenderedOp create(RenderedImage source, ColorIndexer indexer, ROI roi, Range nodata, Integer destNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI(OPERATION_NAME, "rendered");
        pb.setSource("source0", (Object)source);
        pb.setParameter("Indexer", (Object)indexer);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("nodata", (Object)nodata);
        pb.setParameter("destNoData", (Object)destNoData);
        return JAI.create((String)OPERATION_NAME, (ParameterBlock)pb, (RenderingHints)hints);
    }
}

