/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl;

import java.util.Objects;

public abstract class ZoomLevel {
    private int zoomLevel;
    protected int maxTilePerRowNumber;
    protected int maxTilePerColNumber;
    protected long maxTileNumber;

    public ZoomLevel() {
    }

    public ZoomLevel(int zoomLevel) {
        this.setZoomLevel(zoomLevel);
    }

    protected void setZoomLevel(int zoomLevel) {
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("Zoom level must be >= 0.");
        }
        this.zoomLevel = zoomLevel;
        this.maxTilePerRowNumber = this.calculateMaxTilePerRowNumber(zoomLevel);
        this.maxTilePerColNumber = this.calculateMaxTilePerColNumber(zoomLevel);
        this.maxTileNumber = this.calculateMaxTileNumber();
    }

    public abstract int calculateMaxTilePerRowNumber(int var1);

    public abstract int calculateMaxTilePerColNumber(int var1);

    public long calculateMaxTileNumber() {
        return (long)this.maxTilePerColNumber * (long)this.maxTilePerRowNumber;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public int getMaxTilePerRowNumber() {
        return this.maxTilePerRowNumber;
    }

    public int getMaxTilePerColNumber() {
        return this.maxTilePerColNumber;
    }

    public long getMaxTileNumber() {
        return this.maxTileNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoomLevel zoomLevel1 = (ZoomLevel)o;
        return this.zoomLevel == zoomLevel1.zoomLevel && this.maxTilePerRowNumber == zoomLevel1.maxTilePerRowNumber && this.maxTilePerColNumber == zoomLevel1.maxTilePerColNumber && this.maxTileNumber == zoomLevel1.maxTileNumber;
    }

    public int hashCode() {
        return Objects.hash(this.zoomLevel, this.maxTilePerRowNumber, this.maxTilePerColNumber, this.maxTileNumber);
    }
}

