/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.classifier.ColorMapTransform;
import it.geosolutions.jaiext.classifier.LinearColorMap;
import it.geosolutions.jaiext.classifier.LinearColorMapElement;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.api.coverage.SampleDimensionType;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.ErrorKeys;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.SLDColorMapBuilder;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;

class ColorMapNode
extends StyleVisitorCoverageProcessingNodeAdapter
implements StyleVisitor,
CoverageProcessingNode {
    public static int TYPE_NONE = -1;
    private int type = TYPE_NONE;
    private LinearColorMap colorMapTransform;
    private boolean extendedColors;

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(5);
    }

    @Override
    public void visit(ColorMap colorMap) {
        if (colorMap == null) {
            return;
        }
        this.type = colorMap.getType();
        this.extendedColors = colorMap.getExtendedColors();
        ColorMapEntry[] cmEntries = colorMap.getColorMapEntries();
        if (cmEntries != null && cmEntries.length > 0) {
            ColorModel cm;
            CoverageProcessingNode source = this.getSource(0);
            GridCoverageRendererUtilities.ensureSourceNotNull(source, "ColorMapNode");
            GridCoverage2D sourceCoverage = (GridCoverage2D)source.getOutput();
            GridCoverageRendererUtilities.ensureSourceNotNull(sourceCoverage, "ColorMapNode");
            int numSD = sourceCoverage.getNumSampleDimensions();
            if (numSD > 1 && !(cm = sourceCoverage.getRenderedImage().getColorModel()).hasAlpha() && cm.getNumColorComponents() != 2) {
                throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.BAD_BAND_NUMBER_$1, numSD));
            }
            GridSampleDimension candidateSD = sourceCoverage.getSampleDimension(0);
            double[] candidateNoDataValues = ColorMapNode.preparaNoDataValues(candidateSD);
            SLDColorMapBuilder builder = new SLDColorMapBuilder();
            builder.setExtendedColors(this.extendedColors).setLinearColorMapType(this.type).setNumberColorMapEntries(cmEntries.length).setColorForValuesToPreserve(new Color(0, 0, 0, 0)).setGapsColor(new Color(0, 0, 0, 0));
            for (ColorMapEntry cmEntry : cmEntries) {
                builder.addColorMapEntry(cmEntry);
            }
            if (candidateNoDataValues != null && candidateNoDataValues.length > 0) {
                LinearColorMapElement[] noDataCategories = new LinearColorMapElement[candidateNoDataValues.length];
                for (int i = 0; i < noDataCategories.length; ++i) {
                    builder.addValueToPreserve(candidateNoDataValues[i]);
                }
            }
            this.colorMapTransform = builder.buildLinearColorMap();
        } else {
            this.type = TYPE_NONE;
        }
    }

    private static double[] preparaNoDataValues(GridSampleDimension candidateSD) throws IllegalStateException {
        double[] candidateNoDataValues = candidateSD.getNoDataValues();
        if (candidateNoDataValues == null) {
            candidateNoDataValues = new double[1];
            SampleDimensionType sdType = candidateSD.getSampleDimensionType();
            int dataBufferType = TypeMap.getDataBufferType((SampleDimensionType)sdType);
            switch (dataBufferType) {
                case 2: {
                    candidateNoDataValues[0] = -32768.0;
                    break;
                }
                case 3: {
                    candidateNoDataValues[0] = -2.147483648E9;
                    break;
                }
                case 4: {
                    candidateNoDataValues[0] = Double.NaN;
                    break;
                }
                case 5: 
                case 32: {
                    candidateNoDataValues[0] = Double.NaN;
                    break;
                }
                default: {
                    candidateNoDataValues = null;
                }
            }
        }
        return candidateNoDataValues;
    }

    public ColorMapNode() {
        this((Hints)null);
    }

    public ColorMapNode(Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ColorMapNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies a ColorMapTransform following SLD 1.0 spec."));
    }

    protected GridCoverage2D execute() {
        CoverageProcessingNode sourceNode = this.getSource(0);
        GridCoverageRendererUtilities.ensureSourceNotNull(sourceNode, this.getName().toString());
        GridCoverage2D sourceCoverage = (GridCoverage2D)sourceNode.getOutput();
        GridCoverageRendererUtilities.ensureSourceNotNull(sourceCoverage, this.getName().toString());
        if (this.colorMapTransform != null) {
            RenderedImage sourceImage = sourceCoverage.getRenderedImage();
            GridCoverageRendererUtilities.ensureSourceNotNull(sourceImage, this.getName().toString());
            ImageWorker w = new ImageWorker(sourceImage);
            if (w.getNumBands() == 2) {
                w.retainBands(1);
            }
            w.setROI(CoverageUtilities.getROIProperty((GridCoverage2D)sourceCoverage));
            NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty((GridCoverage2D)sourceCoverage);
            w.setNoData(noDataProperty != null ? noDataProperty.getAsRange() : null);
            w.classify((ColorMapTransform)this.colorMapTransform, null);
            RenderedOp classified = w.getRenderedOperation();
            int outputChannels = classified.getColorModel().getNumComponents();
            int numBands = classified.getSampleModel().getNumBands();
            assert (outputChannels == 1 || outputChannels == 3 || outputChannels == 4);
            GridSampleDimension[] sd = new GridSampleDimension[numBands];
            for (int i = 0; i < numBands; ++i) {
                sd[i] = new GridSampleDimension((CharSequence)TypeMap.getColorInterpretation((ColorModel)classified.getColorModel(), (int)i).name());
            }
            HashMap properties = sourceCoverage.getProperties();
            if (properties == null) {
                properties = new HashMap();
            }
            CoverageUtilities.setROIProperty(properties, (ROI)w.getROI());
            CoverageUtilities.setNoDataProperty(properties, (Object)w.getNoData());
            return this.getCoverageFactory().create((CharSequence)("color_mapped_" + sourceCoverage.getName().toString()), (RenderedImage)classified, sourceCoverage.getGridGeometry(), sd, new GridCoverage[]{sourceCoverage}, properties);
        }
        return sourceCoverage;
    }

    public boolean isExtendedColors() {
        return this.extendedColors;
    }

    public int getType() {
        return this.type;
    }
}

