/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

public class ChannelSelectionUpdateStyleVisitor
extends DuplicatingStyleVisitor {
    private SelectedChannelType[] channels;

    public ChannelSelectionUpdateStyleVisitor(SelectedChannelType[] channels) {
        this.channels = channels;
    }

    @Override
    protected ChannelSelection copy(ChannelSelection channelSelection) {
        if (this.channels.length != 3) {
            return this.sf.createChannelSelection(new SelectedChannelType[]{this.channels[0]});
        }
        return this.sf.createChannelSelection(this.channels);
    }

    public static int[] getBandIndicesFromSelectionChannels(RasterSymbolizer symbolizer) {
        int[] bandIndices = null;
        ChannelSelection channelSelection = symbolizer.getChannelSelection();
        if (channelSelection != null) {
            SelectedChannelType grayChannel;
            SelectedChannelType[] channels = channelSelection.getRGBChannels();
            if (channels != null && channels.length > 0 && channels[0] != null) {
                bandIndices = new int[channels.length];
                for (int i = 0; i < channels.length; ++i) {
                    if (channels[i] == null) {
                        return null;
                    }
                    bandIndices[i] = (Integer)channels[i].getChannelName().evaluate(null, Integer.class) - 1;
                }
            }
            if ((grayChannel = channelSelection.getGrayChannel()) != null) {
                bandIndices = new int[]{(Integer)grayChannel.getChannelName().evaluate(null, Integer.class) - 1};
            }
        }
        return bandIndices;
    }
}

