/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;

class LineInfo {
    private double y;
    private List<LineComponent> components = new ArrayList<LineComponent>();

    LineInfo() {
    }

    LineInfo(LineComponent component) {
        this();
        this.components.add(component);
    }

    void add(LineComponent component) {
        this.components.add(component);
    }

    double getWidth() {
        double width = 0.0;
        for (LineComponent lineComponent : this.components) {
            width += lineComponent.getGlyphVector().getLogicalBounds().getWidth();
        }
        return width;
    }

    Rectangle2D getBounds() {
        Rectangle2D vb = null;
        for (LineComponent lineComponent : this.components) {
            Rectangle2D verticalBounds = lineComponent.getGlyphVector().getVisualBounds();
            Rectangle2D horizontalBounds = lineComponent.getGlyphVector().getLogicalBounds();
            if (lineComponent.getText().trim().isEmpty() && this.components.size() == 1) {
                verticalBounds = horizontalBounds;
            }
            Rectangle2D.Double componentBounds = new Rectangle2D.Double(horizontalBounds.getX(), verticalBounds.getY(), horizontalBounds.getWidth(), verticalBounds.getHeight());
            if (vb == null) {
                vb = componentBounds;
                continue;
            }
            Rectangle2D.Double other = new Rectangle2D.Double(vb.getMaxX(), vb.getMinY(), ((RectangularShape)componentBounds).getWidth(), ((RectangularShape)componentBounds).getHeight());
            vb = ((Rectangle2D)vb).createUnion(other);
        }
        return vb;
    }

    void setMinX(double minX) {
        double x = minX;
        for (LineComponent component : this.components) {
            component.setX(x);
            x += component.getGlyphVector().getLogicalBounds().getWidth();
        }
    }

    float getLineOffset() {
        float offset = Float.NEGATIVE_INFINITY;
        for (LineComponent component : this.components) {
            TextLayout layout = component.getLayout();
            float co = layout.getAscent() + layout.getDescent() + layout.getLeading();
            if (!(co > offset)) continue;
            offset = co;
        }
        return offset;
    }

    double getDescentLeading() {
        float descent = Float.NEGATIVE_INFINITY;
        for (LineComponent component : this.components) {
            TextLayout layout = component.getLayout();
            float de = layout.getDescent() + layout.getLeading();
            if (!(de > descent)) continue;
            descent = de;
        }
        return descent;
    }

    double getLineHeight() {
        double height = Double.NEGATIVE_INFINITY;
        for (LineComponent component : this.components) {
            double ch = component.getGlyphVector().getVisualBounds().getHeight();
            if (!(ch > height)) continue;
            height = ch;
        }
        return height;
    }

    float getAscent() {
        float ascent = Float.NEGATIVE_INFINITY;
        for (LineComponent component : this.components) {
            float ca = component.getLayout().getAscent();
            if (!(ca > ascent)) continue;
            return ascent;
        }
        return ascent;
    }

    List<LineComponent> getComponents() {
        return this.components;
    }

    double getY() {
        return this.y;
    }

    void setY(double y) {
        this.y = y;
    }

    static class LineComponent {
        private double x;
        private String text;
        private GlyphVector gv;
        private TextLayout layout;
        Rectangle2D visualBounds;

        LineComponent(String text, GlyphVector gv, TextLayout layout) {
            this.text = text;
            this.gv = gv;
            this.layout = layout;
        }

        Rectangle2D getVisualBounds() {
            if (this.visualBounds == null) {
                this.visualBounds = this.gv.getVisualBounds();
            }
            return this.visualBounds;
        }

        double getX() {
            return this.x;
        }

        void setX(double x) {
            this.x = x;
        }

        String getText() {
            return this.text;
        }

        GlyphVector getGlyphVector() {
            return this.gv;
        }

        TextLayout getLayout() {
            return this.layout;
        }

        LineMetrics computeLineMetrics(FontRenderContext fontRenderContext) {
            return this.gv.getFont().getLineMetrics(this.text, fontRenderContext);
        }
    }
}

