/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.EnumSet;
import java.util.EventObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;

public class MapBoundsEvent
extends EventObject {
    private static final long serialVersionUID = -2063712912599101999L;
    public static final int AREA_OF_INTEREST_MASK = 1;
    public static final int COORDINATE_SYSTEM_MASK = 2;
    private static final int NEXT_FLAG = 4;
    private EnumSet<Type> type;
    private ReferencedEnvelope oldAreaOfInterest;
    private ReferencedEnvelope newAreaOfInterest;

    public MapBoundsEvent(MapContent source, int type, ReferencedEnvelope oldAreaOfInterest, ReferencedEnvelope newAreaOfInterest) {
        super(source);
        this.type = EnumSet.noneOf(Type.class);
        if ((type & 1) != 0) {
            this.type.add(Type.BOUNDS);
        } else if ((type & 2) != 0) {
            this.type.add(Type.CRS);
        } else {
            throw new IllegalArgumentException("Type is not acceptable, maximum value is 3, passed value is " + type);
        }
        this.oldAreaOfInterest = oldAreaOfInterest;
        this.newAreaOfInterest = newAreaOfInterest;
    }

    public MapBoundsEvent(MapViewport source, Type type, ReferencedEnvelope oldBounds, ReferencedEnvelope newBounds) {
        this(source, EnumSet.of(type), oldBounds, newBounds);
    }

    public MapBoundsEvent(MapViewport source, EnumSet<Type> type, ReferencedEnvelope oldBounds, ReferencedEnvelope newBounds) {
        super(source);
        this.type = type;
        this.oldAreaOfInterest = oldBounds;
        this.newAreaOfInterest = newBounds;
    }

    public int getType() {
        int field = 0;
        for (Type t : this.type) {
            field |= t.getMask();
        }
        return field;
    }

    public EnumSet<Type> getEventType() {
        return this.type;
    }

    public CoordinateReferenceSystem getOldCoordinateReferenceSystem() {
        return this.oldAreaOfInterest.getCoordinateReferenceSystem();
    }

    public CoordinateReferenceSystem getNewCoordinateReferenceSystem() {
        return this.newAreaOfInterest.getCoordinateReferenceSystem();
    }

    public ReferencedEnvelope getOldAreaOfInterest() {
        return this.oldAreaOfInterest;
    }

    public ReferencedEnvelope getNewAreaOfInterest() {
        return this.newAreaOfInterest;
    }

    public static enum Type {
        BOUNDS(1),
        CRS(2);

        private final int MASK;

        private Type(int mask) {
            this.MASK = mask;
        }

        public int getMask() {
            return this.MASK;
        }
    }
}

