/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.servlet.ServletContext;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.resource.locator.UriLocator;

public class TemplatesUriLocator
implements UriLocator {
    public static final String URI_PREFIX = "template://";
    public static final String URI_PREFIX_HEADER = "template://header";
    public static final String URI_PREFIX_FOOTER = "template://footer";
    public static final String URI_LOCATOR_ID = "templateURILocator";
    public static final String SRC_MAIN_RESOURCES_FOLDER = "src/main/resources/";

    public InputStream locate(String uri) throws IOException {
        StringBuilder javascript;
        if (uri.startsWith(URI_PREFIX_HEADER)) {
            javascript = this.getHeader();
        } else if (uri.startsWith(URI_PREFIX_FOOTER)) {
            javascript = this.getFooter();
        } else {
            javascript = new StringBuilder();
            final String path = uri.substring(URI_PREFIX.length()).replace('\\', '/');
            ServletContext servletContext = Context.get().getServletContext();
            String realPath = servletContext != null ? servletContext.getRealPath(path) : path;
            if (realPath == null) {
                return new ByteArrayInputStream(javascript.toString().getBytes(StandardCharsets.UTF_8));
            }
            Path folderToVisit = Paths.get(realPath, new String[0]);
            if (Files.exists(folderToVisit, new LinkOption[0])) {
                Files.walkFileTree(folderToVisit, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().endsWith("html")) {
                            String fileFolder = file.getParent().toUri().toString();
                            String relativeFileFolderPath = "";
                            relativeFileFolderPath = fileFolder.contains(TemplatesUriLocator.SRC_MAIN_RESOURCES_FOLDER) ? fileFolder.substring(fileFolder.indexOf(TemplatesUriLocator.SRC_MAIN_RESOURCES_FOLDER) + TemplatesUriLocator.SRC_MAIN_RESOURCES_FOLDER.length() - 1) : fileFolder.substring(fileFolder.indexOf(path));
                            TemplatesUriLocator.this.addFileToTemplateCache(javascript, "../.." + relativeFileFolderPath + file.getFileName(), file.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        return new ByteArrayInputStream(javascript.toString().getBytes(StandardCharsets.UTF_8));
    }

    private void addFileToTemplateCache(StringBuilder javascript, String s, File file) throws IOException {
        StringBuilder template = null;
        template = new StringBuilder();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try (BufferedReader br = new BufferedReader(reader);){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                template.append(sCurrentLine).append("\n");
            }
            String sTemplate = template.toString();
            sTemplate = sTemplate.replaceAll(">[ \\t\\r\\f]*<", "><");
            sTemplate = sTemplate.replaceAll("\\s\\s+", " ");
            sTemplate = sTemplate.replace("\\", "\\\\");
            sTemplate = sTemplate.replaceAll("\\n", "\\\\n");
            sTemplate = sTemplate.replace("'", "\\'");
            javascript.append(String.format("$templateCache.put('%s', '%s');", s, sTemplate));
        }
    }

    private StringBuilder getHeader() {
        StringBuilder javascript = new StringBuilder();
        javascript.append("(function() {").append("angular.module('gn').run(['$templateCache', function($templateCache) {");
        return javascript;
    }

    private StringBuilder getFooter() {
        StringBuilder javascript = new StringBuilder();
        javascript.append("}]);").append("})();");
        return javascript;
    }

    public boolean accept(String uri) {
        return uri.startsWith(URI_PREFIX);
    }
}

