/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ChannelToPortHandler
extends AbstractLoggingBean {
    private final IoSession port;
    private final Channel channel;

    public ChannelToPortHandler(IoSession port, Channel channel) {
        this.port = Objects.requireNonNull(port, "No port IoSession");
        this.channel = Objects.requireNonNull(channel, "No Channel");
    }

    public IoSession getPortSession() {
        return this.port;
    }

    public void handleEof() throws IOException {
        this.port.shutdownOutputStream();
    }

    public void sendToPort(byte cmd, byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data length exceeds int boundaries: %d", (long)len);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone((byte[])data, (int)off, (int)((int)len));
        this.port.writeBuffer((Buffer)buf).addListener(arg_0 -> this.lambda$sendToPort$0(cmd, (Buffer)buf, len, arg_0));
    }

    protected void handleWriteDataSuccess(byte cmd, byte[] data, int off, int len) {
        this.checkWindow(cmd);
    }

    protected void handleWriteDataFailure(byte cmd, byte[] data, int off, int len, Throwable t) {
        this.debug("handleWriteDataFailure({}, {})[{}] failed ({}) to write len={}: {}", this.channel, this.port, SshConstants.getCommandMessageName((int)(cmd & 0xFF)), t.getClass().getSimpleName(), len, t.getMessage(), t);
        if (this.port.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] closing session={}", new Object[]{this.channel, SshConstants.getCommandMessageName((int)(cmd & 0xFF)), this.port});
            }
            this.checkWindow(cmd);
            this.channel.close(false);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] ignoring writeDataFailure {} because ioSession {} is already closing ", new Object[]{this.channel, SshConstants.getCommandMessageName((int)(cmd & 0xFF)), t, this.port});
            }
            this.checkWindow(cmd);
        }
    }

    private void checkWindow(byte cmd) {
        try {
            LocalWindow wLocal = this.channel.getLocalWindow();
            if (wLocal.isOpen()) {
                wLocal.check();
            }
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to check local window: {}", new Object[]{this.channel, SshConstants.getCommandMessageName((int)(cmd & 0xFF)), e.getClass().getSimpleName(), e.getMessage()});
            }
            this.channel.getSession().exceptionCaught(e);
        }
    }

    private /* synthetic */ void lambda$sendToPort$0(byte cmd, Buffer buf, long len, IoWriteFuture future) {
        if (future.isWritten()) {
            this.handleWriteDataSuccess(cmd, buf.array(), 0, (int)len);
        } else {
            this.handleWriteDataFailure(cmd, buf.array(), 0, (int)len, future.getException());
        }
    }
}

