/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.auditable;

import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.auditable.AuditableEntity;
import org.hibernate.envers.Audited;

@Entity
@Access(value=AccessType.PROPERTY)
@Audited(withModifiedFlag=true)
public class UserAuditable
extends AuditableEntity {
    private int id;
    private String profile;
    private String username;
    private String name;
    private String surname;
    private String emailAddress;
    private String organisation;
    private String address;
    private String city;
    private String state;
    private String zip;
    private String country;
    private String kind;
    private String groupsRegisteredUser;
    private String groupsEditor;
    private String groupsReviewer;
    private String groupsUserAdmin;
    private boolean enabled;

    public static UserAuditable build(User user, List<UserGroup> userGroups) {
        UserAuditable userAuditable = new UserAuditable();
        userAuditable.setId(user.getId());
        userAuditable.setUsername(user.getUsername());
        userAuditable.setName(user.getName());
        userAuditable.setSurname(user.getSurname());
        userAuditable.setEnabled(user.isEnabled());
        userAuditable.setKind(user.getKind());
        userAuditable.setOrganisation(user.getOrganisation());
        userAuditable.setProfile(user.getProfile().name());
        if (!user.getEmailAddresses().isEmpty()) {
            userAuditable.setEmailAddress((String)user.getEmailAddresses().toArray()[0]);
        }
        if (!user.getAddresses().isEmpty()) {
            Address userAddress = (Address)user.getAddresses().toArray()[0];
            userAuditable.setAddress(userAddress.getAddress());
            userAuditable.setZip(userAddress.getZip());
            userAuditable.setState(userAddress.getState());
            userAuditable.setCity(userAddress.getCity());
            userAuditable.setCountry(userAddress.getCountry());
        }
        userAuditable.setEnabled(user.isEnabled());
        TreeSet groupsRegisteredUserList = new TreeSet();
        TreeSet groupsEditorList = new TreeSet();
        TreeSet groupsReviewerList = new TreeSet();
        TreeSet groupsUserAdminList = new TreeSet();
        if (userGroups != null) {
            userGroups.forEach(userGroup -> {
                switch (userGroup.getProfile()) {
                    case RegisteredUser: {
                        groupsRegisteredUserList.add(userGroup.getGroup().getName());
                        break;
                    }
                    case Editor: {
                        groupsEditorList.add(userGroup.getGroup().getName());
                        break;
                    }
                    case Reviewer: {
                        groupsReviewerList.add(userGroup.getGroup().getName());
                        break;
                    }
                    case UserAdmin: {
                        groupsUserAdminList.add(userGroup.getGroup().getName());
                        break;
                    }
                }
            });
        }
        userAuditable.setGroupsRegisteredUser(StringUtils.join(groupsRegisteredUserList, (String)","));
        userAuditable.setGroupsEditor(StringUtils.join(groupsEditorList, (String)","));
        userAuditable.setGroupsReviewer(StringUtils.join(groupsReviewerList, (String)","));
        userAuditable.setGroupsUserAdmin(StringUtils.join(groupsUserAdminList, (String)","));
        return userAuditable;
    }

    @Id
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nonnull String username) {
        this.username = username;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddresses) {
        this.emailAddress = emailAddresses;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getGroupsRegisteredUser() {
        return this.groupsRegisteredUser;
    }

    public void setGroupsRegisteredUser(String groupsRegisteredUser) {
        this.groupsRegisteredUser = groupsRegisteredUser;
    }

    public String getGroupsEditor() {
        return this.groupsEditor;
    }

    public void setGroupsEditor(String groupsEditor) {
        this.groupsEditor = groupsEditor;
    }

    public String getGroupsReviewer() {
        return this.groupsReviewer;
    }

    public void setGroupsReviewer(String groupsReviewer) {
        this.groupsReviewer = groupsReviewer;
    }

    public String getGroupsUserAdmin() {
        return this.groupsUserAdmin;
    }

    public void setGroupsUserAdmin(String groupsUserAdmin) {
        this.groupsUserAdmin = groupsUserAdmin;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

