/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg.hsql;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.referencing.factory.epsg.hsql.FactoryUsingHSQL;
import org.geotools.util.Utilities;
import org.geotools.util.Version;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.hsqldb.jdbc.JDBCDataSource;

public class ThreadedHsqlEpsgFactory
extends ThreadedEpsgFactory {
    public static final Logger LOGGER = Logging.getLogger(ThreadedHsqlEpsgFactory.class);
    public static final Version VERSION = new Version("9.6.1");
    public static final String DIRECTORY_KEY = "EPSG-HSQL.directory";
    private static final String ZIP_FILE = "EPSG.zip";
    public static final String DATABASE_NAME = "EPSG";
    static final String MARKER_FILE = "EPSG_creation_marker.txt";
    static final String LOCK_FILE = "EPSG_creation_lock.txt";
    static final String PREFIX = "jdbc:hsqldb:file:";

    public ThreadedHsqlEpsgFactory() {
        this((Hints)null);
    }

    public ThreadedHsqlEpsgFactory(Hints hints) {
        super(hints, 91);
    }

    private static File getDirectory() {
        try {
            File directory;
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && ((directory = new File(property)).isDirectory() || directory.mkdir())) {
                return directory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ThreadedHsqlEpsgFactory.getTemporaryDirectory();
    }

    private static File getTemporaryDirectory() {
        File directory = new File(System.getProperty("java.io.tmpdir", "."), "GeoTools");
        if ((directory.isDirectory() || directory.mkdir()) && ((directory = new File(directory, "Databases/HSQL")).isDirectory() || directory.mkdirs())) {
            return directory;
        }
        return null;
    }

    private static File getDirectory(DataSource source) {
        String path;
        if (source instanceof JDBCDataSource && (path = ((JDBCDataSource)source).getDatabase()) != null && PREFIX.regionMatches(true, 0, path, 0, PREFIX.length())) {
            path = path.substring(PREFIX.length());
            return new File(path).getParentFile();
        }
        return null;
    }

    @Override
    protected DataSource createDataSource() throws SQLException {
        Logger logger = Logging.getLogger(ThreadedHsqlEpsgFactory.class);
        logger.log(Level.FINE, "Building new data source for " + ((Object)((Object)this)).getClass().getName());
        DataSource candidate = super.createDataSource();
        if (candidate instanceof JDBCDataSource) {
            return candidate;
        }
        JDBCDataSource source = new JDBCDataSource();
        File directory = new File(ThreadedHsqlEpsgFactory.getDirectory(), "v" + VERSION);
        if (directory != null) {
            StringBuilder url = new StringBuilder(PREFIX);
            String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            url.append(DATABASE_NAME);
            url.append(";shutdown=true;readonly=true");
            source.setDatabase(url.toString());
        }
        source.setUser("SA");
        return source;
    }

    private static boolean dataExists(File directory) throws SQLException {
        return new File(directory, MARKER_FILE).exists() && new File(directory, "EPSG.data").exists() && new File(directory, "EPSG.properties").exists() && new File(directory, "EPSG.script").exists();
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        block15: {
            Logger logger = Logging.getLogger(ThreadedHsqlEpsgFactory.class);
            logger.log(Level.FINE, "Building backing store for " + ((Object)((Object)this)).getClass().getName());
            DataSource source = this.getDataSource();
            File directory = ThreadedHsqlEpsgFactory.getDirectory(source);
            directory.mkdirs();
            if (!ThreadedHsqlEpsgFactory.dataExists(directory)) {
                FileLock lock = null;
                try {
                    lock = this.acquireLock(directory);
                    if (ThreadedHsqlEpsgFactory.dataExists(directory)) break block15;
                    LogRecord record = Loggings.format((Level)Level.FINE, (int)17, (Object)VERSION);
                    record.setLoggerName(logger.getName());
                    logger.log(record);
                    ZipInputStream zin = new ZipInputStream(ThreadedHsqlEpsgFactory.class.getResourceAsStream(ZIP_FILE));
                    ZipEntry ze = null;
                    byte[] buf = new byte[1024];
                    int read = 0;
                    while ((ze = zin.getNextEntry()) != null) {
                        try {
                            Utilities.assertNotZipSlipVulnarable((File)new File(directory, ze.getName()), (Path)directory.toPath());
                        }
                        catch (IOException zipSlipVulnerable) {
                            LOGGER.fine("Expected Reference to internal jar:" + zipSlipVulnerable);
                        }
                        FileOutputStream fout = new FileOutputStream(new File(directory, ze.getName()));
                        while ((read = zin.read(buf)) > 0) {
                            fout.write(buf, 0, read);
                        }
                        zin.closeEntry();
                        fout.close();
                    }
                    zin.close();
                    new File(directory, MARKER_FILE).createNewFile();
                }
                catch (IOException exception) {
                    SQLException e = new SQLException(MessageFormat.format("Can't read file \"{0}\".", ZIP_FILE));
                    e.initCause(exception);
                    throw e;
                }
                finally {
                    if (lock != null) {
                        try {
                            lock.release();
                            lock.channel().close();
                            new File(directory, LOCK_FILE).delete();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        FactoryUsingHSQL factory = new FactoryUsingHSQL(hints, this.getDataSource()){

            @Override
            protected void shutdown(boolean active) throws SQLException {
            }
        };
        factory.setValidationQuery("CALL NOW()");
        return factory;
    }

    FileLock acquireLock(File directory) throws IOException {
        File file = new File(directory, LOCK_FILE);
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        FileLock lock = channel.lock();
        while (!lock.isValid()) {
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return lock;
    }
}

