/*
 * Decompiled with CFR 0.152.
 */
package org.geonetwork.messaging;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.context.ApplicationEvent;

public class JMSMessager {
    private String jmsUrl;

    public String getJmsUrl() {
        return this.jmsUrl;
    }

    public void setJmsUrl(String jmsUrl) {
        this.jmsUrl = jmsUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String queue, ApplicationEvent event) {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.jmsUrl);
            connection.start();
            try (Connection connection = connectionFactory.createConnection();
                 Session session = connection.createSession(false, 1);){
                Queue destination = session.createQueue(queue);
                MessageProducer producer = session.createProducer((Destination)destination);
                producer.setDeliveryMode(1);
                ObjectMessage message = session.createObjectMessage((Serializable)event);
                producer.send((Message)message);
            }
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }
}

