/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.core.CheckedRunnable;

abstract class SearchPhase
implements CheckedRunnable<IOException> {
    private final String name;

    protected SearchPhase(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        try {
            this.run();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void doCheckNoMissingShards(String phaseName, SearchRequest request, GroupShardsIterator<SearchShardIterator> shardsIts) {
        assert (request.allowPartialSearchResults() != null) : "SearchRequest missing setting for allowPartialSearchResults";
        if (!request.allowPartialSearchResults().booleanValue()) {
            StringBuilder missingShards = new StringBuilder();
            for (int index = 0; index < shardsIts.size(); ++index) {
                SearchShardIterator shardRoutings = shardsIts.get(index);
                if (shardRoutings.size() != 0) continue;
                if (!missingShards.isEmpty()) {
                    missingShards.append(", ");
                }
                missingShards.append(shardRoutings.shardId());
            }
            if (!missingShards.isEmpty()) {
                String msg = "Search rejected due to missing shards [" + missingShards + "]. Consider using `allow_partial_search_results` setting to bypass this error.";
                throw new SearchPhaseExecutionException(phaseName, msg, null, ShardSearchFailure.EMPTY_ARRAY);
            }
        }
    }
}

