/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetPipelineRequest
extends MasterNodeReadRequest<GetPipelineRequest> {
    private String[] ids;
    private final boolean summary;

    public GetPipelineRequest(boolean summary, String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("ids cannot be null");
        }
        this.ids = ids;
        this.summary = summary;
    }

    public GetPipelineRequest(String ... ids) {
        this(false, ids);
    }

    GetPipelineRequest() {
        this(false, Strings.EMPTY_ARRAY);
    }

    public GetPipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.ids = in.readStringArray();
        this.summary = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.ids);
        out.writeBoolean(this.summary);
    }

    public String[] getIds() {
        return this.ids;
    }

    public boolean isSummary() {
        return this.summary;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

