/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoMetrics;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class NodesInfoRequest
extends BaseNodesRequest<NodesInfoRequest> {
    private final NodesInfoMetrics nodesInfoMetrics;

    public NodesInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.nodesInfoMetrics = new NodesInfoMetrics(in);
    }

    public NodesInfoRequest(String ... nodesIds) {
        super(nodesIds);
        this.nodesInfoMetrics = new NodesInfoMetrics();
        this.all();
    }

    public NodesInfoRequest clear() {
        this.nodesInfoMetrics.requestedMetrics().clear();
        return this;
    }

    public NodesInfoRequest all() {
        this.nodesInfoMetrics.requestedMetrics().addAll(NodesInfoMetrics.Metric.allMetrics());
        return this;
    }

    public Set<String> requestedMetrics() {
        return Set.copyOf(this.nodesInfoMetrics.requestedMetrics());
    }

    public NodesInfoRequest addMetric(String metric) {
        if (!NodesInfoMetrics.Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.nodesInfoMetrics.requestedMetrics().add(metric);
        return this;
    }

    public NodesInfoRequest addMetrics(String ... metrics) {
        TreeSet<String> metricsSet = new TreeSet<String>(Set.of(metrics));
        return this.addMetrics(metricsSet);
    }

    public NodesInfoRequest addMetrics(Set<String> metricsSet) {
        if (!NodesInfoMetrics.Metric.allMetrics().containsAll(metricsSet)) {
            metricsSet.removeAll(NodesInfoMetrics.Metric.allMetrics());
            String plural = metricsSet.size() == 1 ? "" : "s";
            throw new IllegalStateException("Used illegal metric" + plural + ": " + metricsSet);
        }
        this.nodesInfoMetrics.requestedMetrics().addAll(metricsSet);
        return this;
    }

    public NodesInfoRequest removeMetric(String metric) {
        if (!NodesInfoMetrics.Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.nodesInfoMetrics.requestedMetrics().remove(metric);
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.nodesInfoMetrics.writeTo(out);
    }

    public NodesInfoMetrics getNodesInfoMetrics() {
        return this.nodesInfoMetrics;
    }
}

