/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.selections;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.Selection;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserSavedSelection;
import org.fao.geonet.domain.UserSavedSelectionId;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.SelectionRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/userselections"})
@Tag(name="userselections", description="User selections related operations")
@Controller(value="userselections")
public class UserSelectionsApi {
    @Autowired
    SelectionRepository selectionRepository;
    @Autowired
    UserSavedSelectionRepository umsRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    LanguageRepository langRepository;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    IMetadataIndexer metadataIndexer;

    @Operation(summary="Get list of user selection sets")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public List<Selection> getSelectionList() throws Exception {
        return this.selectionRepository.findAll();
    }

    @Operation(summary="Add a user selection set")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Selection created."), @ApiResponse(responseCode="400", description="A selection with that id or name already exist."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseBody
    public ResponseEntity createPersistentSelectionType(@Parameter(name="selection") @RequestBody Selection selection) throws Exception {
        Optional existingSelectionById = this.selectionRepository.findById((Object)selection.getId());
        if (existingSelectionById.isPresent()) {
            throw new IllegalArgumentException(String.format("A selection with id '%d' already exist. Choose another id or unset it.", selection.getId()));
        }
        Selection existingSelection = this.selectionRepository.findOneByName(selection.getName());
        if (existingSelection != null) {
            throw new IllegalArgumentException(String.format("A selection with name '%s' already exist. Choose another name.", selection.getName()));
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = selection.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            selection.getLabelTranslations().put(l.getId(), label == null ? selection.getName() : label);
        }
        this.selectionRepository.save((Object)selection);
        return new ResponseEntity((Object)selection.getId(), HttpStatus.CREATED);
    }

    @Operation(summary="Update a user selection set", description="")
    @RequestMapping(value={"/{selectionIdentifier}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Selection updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Selection not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public ResponseEntity updateUserSelection(@Parameter(description="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @Parameter(name="selection") @RequestBody Selection selection) throws Exception {
        Optional existingSelection = this.selectionRepository.findById((Object)selectionIdentifier);
        if (!existingSelection.isPresent()) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        selection.setId(selectionIdentifier.intValue());
        this.selectionRepository.save((Object)selection);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(summary="Remove a user selection set", description="")
    @RequestMapping(value={"/{selectionIdentifier}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Selection removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Selection not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public ResponseEntity deleteUserSelection(@Parameter(description="Selection identifier", required=true) @PathVariable Integer selectionIdentifier) throws Exception {
        Optional selection = this.selectionRepository.findById((Object)selectionIdentifier);
        if (!selection.isPresent()) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        this.umsRepository.deleteAllBySelection(selectionIdentifier);
        this.selectionRepository.deleteById((Object)selectionIdentifier);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(summary="Get record in a user selection set")
    @RequestMapping(method={RequestMethod.GET}, value={"/{selectionIdentifier}/{userIdentifier}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Guest')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public List<String> getSelectionRecords(@Parameter(description="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @Parameter(description="User identifier", required=true) @PathVariable Integer userIdentifier, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        Optional<User> user = this.checkUserAllowed(httpSession, userIdentifier);
        Optional selection = this.selectionRepository.findById((Object)selectionIdentifier);
        if (!selection.isPresent()) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        return this.umsRepository.findMetadata(selectionIdentifier, userIdentifier);
    }

    @Operation(summary="Add items to a user selection set")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{selectionIdentifier}/{userIdentifier}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Guest')")
    @ResponseBody
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Records added to selection set."), @ApiResponse(responseCode="404", description="Selection or user or at least one UUID not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    public ResponseEntity<String> addToUserSelection(@Parameter(description="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @Parameter(description="User identifier", required=true) @PathVariable Integer userIdentifier, @Parameter(description="One or more record UUIDs.", required=false) @RequestParam(required=false) String[] uuid, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        Optional<User> user = this.checkUserAllowed(httpSession, userIdentifier);
        Optional selection = this.selectionRepository.findById((Object)selectionIdentifier);
        if (!selection.isPresent()) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        for (String u : uuid) {
            if (this.metadataRepository.existsMetadataUuid(u)) {
                UserSavedSelection e = new UserSavedSelection((Selection)selection.get(), user.get(), u);
                try {
                    this.umsRepository.save((Object)e);
                    this.metadataIndexer.indexMetadata(this.metadataRepository.getMetadataId(u), true, IndexingMode.full);
                }
                catch (Exception e1) {
                    Log.error((String)"geonetwork.api", (String)("UserSelectionsApi - addToUserSelection: " + e1.getMessage()), (Throwable)e1);
                }
                continue;
            }
            return new ResponseEntity((Object)u, HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Operation(summary="Remove items to a user selection set")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{selectionIdentifier}/{userIdentifier}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Guest')")
    @ResponseBody
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Items removed from a set.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Selection or user not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    public ResponseEntity deleteFromUserSelection(@Parameter(description="Selection identifier", required=true) @PathVariable Integer selectionIdentifier, @Parameter(description="User identifier", required=true) @PathVariable Integer userIdentifier, @Parameter(description="One or more record UUIDs. If null, remove all.", required=false) @RequestParam(required=false) String[] uuid, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        Optional<User> user = this.checkUserAllowed(httpSession, userIdentifier);
        Optional selection = this.selectionRepository.findById((Object)selectionIdentifier);
        if (!selection.isPresent()) {
            throw new ResourceNotFoundException(String.format("Selection with id '%d' does not exist.", selectionIdentifier));
        }
        if (uuid == null || uuid.length == 0) {
            this.umsRepository.deleteAllBySelectionAndUser(selectionIdentifier, userIdentifier);
        } else {
            for (String u : uuid) {
                UserSavedSelectionId e = new UserSavedSelectionId().setSelectionId(selectionIdentifier.intValue()).setUserId(userIdentifier.intValue()).setMetadataUuid(u);
                this.umsRepository.deleteById((Object)e);
                this.metadataIndexer.indexMetadata(this.metadataRepository.getMetadataId(u), true, IndexingMode.full);
            }
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Optional<User> checkUserAllowed(HttpSession httpSession, Integer userIdentifier) throws ResourceNotFoundException {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        String myUserId = session.getUserId();
        if (myProfile.equals((Object)Profile.Administrator) || myProfile.equals((Object)Profile.UserAdmin) || myUserId.equals(Integer.toString(userIdentifier))) {
            List myUserGroupsAsUserAdmin;
            List adminlist;
            Optional user = this.userRepository.findById((Object)userIdentifier);
            if (!user.isPresent()) {
                throw new ResourceNotFoundException(String.format("User with id '%d' does not exist.", userIdentifier));
            }
            if (!myUserId.equals(Integer.toString(userIdentifier)) && myProfile == Profile.UserAdmin && (adminlist = this.userGroupRepository.findGroupIds(Specification.where((Specification)UserGroupSpecs.hasGroupIds((List)(myUserGroupsAsUserAdmin = this.userGroupRepository.findGroupIds(Specification.where((Specification)UserGroupSpecs.hasUserId((int)Integer.parseInt(myUserId))).and(UserGroupSpecs.hasProfile((Profile)Profile.UserAdmin)))))).and(UserGroupSpecs.hasUserId((int)userIdentifier)))).isEmpty()) {
                throw new IllegalArgumentException("You don't have rights to do this because the user you want to edit is not part of your group");
            }
            return user;
        }
        throw new IllegalArgumentException("You don't have rights to do this");
    }
}

