/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.registries.CrsUtils;
import org.fao.geonet.api.registries.model.Crs;
import org.fao.geonet.api.registries.model.CrsType;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/registries"})
@Tag(name="registries", description="Registries related operations")
public class CrsApi {
    public static final String DEFAULT_PARAMS_ROWS = "100";

    @Operation(summary="Get list of CRS type", description="")
    @RequestMapping(value={"/crs/types"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of CRS types.")})
    @ResponseBody
    public List<CrsType> getCrsTypes() throws Exception {
        return Arrays.asList(CrsType.values());
    }

    @Operation(summary="Search coordinate reference system (CRS)", description="Based on GeoTools EPSG database. If phrase query, each words are searched separately.")
    @RequestMapping(value={"/crs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of CRS.")})
    @ResponseBody
    public List<Crs> searchCrs(@Parameter(description="Search value", required=false) @RequestParam(required=false, defaultValue="") String q, @Parameter(description="Type of CRS", required=false) @RequestParam(required=false) CrsType type, @Parameter(description="Number of results. Default is: 100", required=false) @RequestParam(required=false, defaultValue="100") int rows) throws Exception {
        List<Crs> crsList = CrsUtils.search(q.split(" "), type, rows);
        return crsList;
    }

    @Operation(summary="Get CRS", description="")
    @RequestMapping(value={"/crs/{id}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="CRS details."), @ApiResponse(responseCode="404", description="CRS not found.")})
    @ResponseBody
    public Crs getCrs(@Parameter(description="CRS identifier", required=true) @PathVariable String id) throws Exception {
        Crs crs = CrsUtils.getById(id);
        if (crs != null) {
            return crs;
        }
        throw new ResourceNotFoundException(String.format("CRS with id '%s' not found in EPSG database", id));
    }
}

