/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.editing;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.editing.EditUtils;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.AddElemValue;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.MultilingualSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.schema.iso19139.ISO19139Namespaces;
import org.fao.geonet.utils.Log;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class AjaxEditUtils
extends EditUtils {
    public AjaxEditUtils(ServiceContext context) {
        super(context);
    }

    protected static Element getMetadataFromSession(UserSession session, String id) throws ResourceNotFoundException {
        Element md;
        if (Log.isDebugEnabled((String)"geonetwork.editor")) {
            Log.debug((String)"geonetwork.editor", (Object)("Retrieving metadata from session " + session.getUserId()));
        }
        if ((md = (Element)session.getProperty("metadata.editing" + id)) == null) {
            throw new ResourceNotFoundException(String.format("Requested metadata with id '%s' is not available in current session. Open an editing session on this record first.", id));
        }
        md.detach();
        return md;
    }

    protected Element applyChangesEmbedded(String id, Map<String, String> changes, String currVersion) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        String schema = this.dataManager.getMetadataSchema(id);
        MetadataSchema metadataSchema = this.dataManager.getSchema(schema);
        EditLib editLib = this.dataManager.getEditLib();
        if (currVersion != null && !editLib.getVersion(id).equals(currVersion)) {
            Log.error((String)"geonetwork.editor", (Object)("Version mismatch: had " + currVersion + " but expected " + editLib.getVersion(id)));
            return null;
        }
        Element md = AjaxEditUtils.getMetadataFromSession(this.session, id);
        HashMap<String, String> xmlInputs = new HashMap<String, String>();
        LinkedHashMap<String, AddElemValue> xmlAndXpathInputs = new LinkedHashMap<String, AddElemValue>();
        for (Map.Entry<String, String> entry : changes.entrySet()) {
            String originalRef = entry.getKey().trim();
            String ref = null;
            String value = entry.getValue().trim();
            String originalAttributeName = null;
            String parsedAttributeName = null;
            if (originalRef.equals("") || originalRef.startsWith("X") || originalRef.startsWith("P") || originalRef.startsWith("lang_") || !this.refIsAttribute(originalRef)) continue;
            originalAttributeName = this.parseRefAndGetAttribute(originalRef);
            ref = this.parseRefAndGetNewRef(originalRef);
            Pair<Namespace, String> attributePair = this.parseAttributeName(originalAttributeName, "COLON", id, md, editLib);
            parsedAttributeName = ((Namespace)attributePair.one()).getPrefix() + ":" + (String)attributePair.two();
            String actualRef = ref != null ? ref : originalRef;
            Element el = editLib.findElement(md, actualRef);
            if (el == null) {
                Log.error((String)"geonetwork.editor", (Object)("Element not found at ref = " + originalRef));
                continue;
            }
            SchemaPlugin schemaPlugin = SchemaManager.getSchemaPlugin((String)schema);
            schemaPlugin.processElement(el, originalRef, parsedAttributeName, value);
        }
        for (Map.Entry<String, String> entry : changes.entrySet()) {
            Element el;
            String ref = entry.getKey().trim();
            String value = entry.getValue().trim();
            String attribute = null;
            if (ref.equals("")) continue;
            if (ref.startsWith("X")) {
                ref = ref.substring(1);
                xmlInputs.put(ref, value);
                continue;
            }
            if (ref.startsWith("P") && ref.endsWith("_xml")) continue;
            if (ref.startsWith("P") && !ref.endsWith("_xml")) {
                String snippet = changes.get(ref + "_xml");
                if (Log.isDebugEnabled((String)"geonetwork.editor")) {
                    Log.debug((String)"geonetwork.editor", (Object)("Add element by XPath: " + value));
                    Log.debug((String)"geonetwork.editor", (Object)("  Snippet is : " + snippet));
                }
                if (snippet != null && !"".equals(snippet)) {
                    xmlAndXpathInputs.put(value, new AddElemValue(snippet));
                    continue;
                }
                Log.warning((String)"geonetwork.editor", (Object)("No XML snippet or value found for xpath " + value + " and element ref " + ref));
                continue;
            }
            if (ref.startsWith("lang_")) {
                this.updatedLocalizedTextElement(md, schema, ref, value, editLib);
                continue;
            }
            int at = ref.indexOf(95);
            if (at != -1) {
                attribute = ref.substring(at + 1);
                ref = ref.substring(0, at);
            }
            if ((el = editLib.findElement(md, ref)) == null) {
                Log.error((String)"geonetwork.editor", (Object)("Element not found at ref = " + ref));
                continue;
            }
            if (attribute != null) {
                Namespace attrNS;
                Pair<Namespace, String> attInfo = this.parseAttributeName(attribute, "COLON", id, md, editLib);
                String localname = (String)attInfo.two();
                if (el.getAttribute(localname, attrNS = (Namespace)attInfo.one()) == null) continue;
                el.setAttribute(new Attribute(localname, value, attrNS));
                continue;
            }
            List content = el.getContent();
            Iterator iterator = content.iterator();
            while (iterator.hasNext()) {
                Content content2 = (Content)iterator.next();
                if (!(content2 instanceof Text)) continue;
                iterator.remove();
            }
            el.addContent(value);
        }
        if (!xmlInputs.isEmpty()) {
            editLib.addXMLFragments(schema, md, xmlInputs);
        }
        if (!xmlAndXpathInputs.isEmpty()) {
            editLib.addElementOrFragmentFromXpaths(md, xmlAndXpathInputs, metadataSchema, true);
        }
        this.setMetadataIntoSession(this.session, (Element)md.clone(), id);
        editLib.removeEditingInfo(md);
        editLib.contractElements(md);
        return (Element)md.detach();
    }

    private String parseRefAndGetNewRef(String ref) {
        String newRef = ref;
        int underscorePosition = ref.indexOf(95);
        if (underscorePosition != -1) {
            newRef = ref.substring(0, underscorePosition);
        }
        return newRef;
    }

    private String parseRefAndGetAttribute(String ref) {
        String attribute = null;
        int underscorePosition = ref.indexOf(95);
        if (underscorePosition != -1) {
            attribute = ref.substring(underscorePosition + 1);
        }
        return attribute;
    }

    private boolean refIsAttribute(String ref) {
        return ref.indexOf(95) != -1;
    }

    private void setMetadataIntoSession(UserSession session, Element md, String id) {
        if (Log.isDebugEnabled((String)"geonetwork.editor")) {
            Log.debug((String)"geonetwork.editor", (Object)("Storing metadata in session " + session.getUserId()));
        }
        session.setProperty("metadata.editing" + id, (Object)md);
    }

    public void removeMetadataEmbedded(UserSession session, String id) {
        if (Log.isDebugEnabled((String)"geonetwork.editor")) {
            Log.debug((String)"geonetwork.editor", (Object)("Removing metadata from session " + session.getUserId()));
        }
        session.removeProperty("metadata.editing" + id);
        session.removeProperty("validation.report" + id);
    }

    public Element getMetadataEmbedded(ServiceContext srvContext, String id, boolean forEditing, boolean withValidationErrors) throws Exception {
        boolean keepXlinkAttributes = false;
        Element md = this.dataManager.getMetadata(srvContext, id, forEditing, withValidationErrors, keepXlinkAttributes);
        UserSession session = srvContext.getUserSession();
        this.setMetadataIntoSession(session, md, id);
        return md;
    }

    public synchronized List<Element> addElementEmbedded(UserSession session, String id, String ref, String name, String childName) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        String schema = this.dataManager.getMetadataSchema(id);
        Element md = AjaxEditUtils.getMetadataFromSession(session, id);
        EditLib editLib = this.dataManager.getEditLib();
        Element el = editLib.findElement(md, ref);
        if (el == null) {
            throw new IllegalStateException("Element not found at ref = " + ref);
        }
        Element info = null;
        if (md.getChild("info", Edit.NAMESPACE) != null) {
            info = (Element)md.getChild("info", Edit.NAMESPACE).clone();
            md.removeChild("info", Edit.NAMESPACE);
        }
        List<Element> children = new ArrayList<Element>();
        MetadataSchema mds = this.dataManager.getSchema(schema);
        if (childName != null) {
            Element child;
            if (childName.equals("geonet:attribute")) {
                child = null;
                String defaultValue = "";
                List attributeDefs = el.getChildren("attribute", Edit.NAMESPACE);
                for (Element attributeDef : attributeDefs) {
                    if (attributeDef == null || !attributeDef.getAttributeValue("name").equals(name)) continue;
                    Element defaultChild = attributeDef.getChild("default", Edit.NAMESPACE);
                    if (defaultChild != null) {
                        defaultValue = defaultChild.getAttributeValue("value");
                    }
                    attributeDef.removeAttribute("add");
                    attributeDef.setAttribute(new Attribute("del", "true"));
                }
                Pair<Namespace, String> attInfo = this.parseAttributeName(name, ":", id, md, editLib);
                el.setAttribute(new Attribute((String)attInfo.two(), defaultValue, (Namespace)attInfo.one()));
                child = el;
                children.add(child);
            } else {
                child = editLib.addElement(mds, el, name);
                if (!childName.equals("")) {
                    String uChildName = editLib.getUnqualifiedName(childName);
                    String prefix = editLib.getPrefix(childName);
                    String ns = editLib.getNamespace(childName, md, mds);
                    if (prefix.equals("")) {
                        prefix = editLib.getPrefix(el.getName());
                        ns = editLib.getNamespace(el.getName(), md, mds);
                    }
                    Element orChild = new Element(uChildName, prefix, ns);
                    child.addContent((Content)orChild);
                    editLib.fillElement(schema, child, orChild);
                }
                children.add(child);
            }
        } else {
            List metadataLanguages = new ArrayList();
            if (mds.getSchemaPlugin() instanceof MultilingualSchemaPlugin) {
                metadataLanguages = ((MultilingualSchemaPlugin)mds.getSchemaPlugin()).getMetadataLanguages(md);
            }
            children = editLib.addElements(mds, el, name, metadataLanguages);
        }
        if (!(childName != null && childName.equals("geonet:attribute") || children == null)) {
            for (Element c : children) {
                int iRef = editLib.findMaximumRef(md);
                editLib.enumerateTreeStartingAt(c, iRef + 1, Integer.parseInt(ref));
                editLib.expandTree(mds, c);
            }
        }
        if (info != null && children != null) {
            for (Element c : children) {
                c.removeChild("info", Edit.NAMESPACE);
                c.addContent((Content)((Element)info.clone()));
            }
        }
        if (childName != null && childName.equals("gmx:Anchor") && children != null) {
            for (Element c : children) {
                if (c.getChild("CharacterString", ISO19139Namespaces.GCO) == null) continue;
                c.removeChild("CharacterString", ISO19139Namespaces.GCO);
            }
        }
        if (info != null) {
            md.addContent((Content)((Element)info.clone()));
        }
        this.setMetadataIntoSession(session, (Element)md.clone(), id);
        return children;
    }

    public synchronized Element deleteElementEmbedded(UserSession session, String id, String ref, String parentRef) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        String schema = this.dataManager.getMetadataSchema(id);
        Element md = AjaxEditUtils.getMetadataFromSession(session, id);
        Element info = (Element)md.getChild("info", Edit.NAMESPACE).clone();
        md.removeChild("info", Edit.NAMESPACE);
        EditLib editLib = this.dataManager.getEditLib();
        Element el = editLib.findElement(md, ref);
        if (el == null) {
            throw new IllegalStateException("Element not found at ref = " + ref);
        }
        String uName = el.getName();
        Namespace ns = el.getNamespace();
        Element parent = el.getParentElement();
        Element result = null;
        if (parent != null) {
            int me = parent.indexOf((Content)el);
            ElementFilter elFilter = new ElementFilter(uName, ns);
            if (parent.getContent((Filter)elFilter).size() == 1) {
                ElementFilter chFilter = new ElementFilter("child", Edit.NAMESPACE);
                List children = parent.getContent((Filter)chFilter);
                for (Element ch : children) {
                    String name = ch.getAttributeValue("name");
                    if (name == null || !name.equals(uName)) continue;
                    result = (Element)ch.clone();
                    break;
                }
                parent.removeContent(me);
                if (result == null) {
                    result = editLib.createElement(schema, el, parent);
                    parent.addContent(me, (Content)result);
                }
                result.setAttribute("parent", parentRef);
                result.addContent((Content)info);
            } else {
                parent.removeContent(me);
            }
        } else {
            throw new IllegalStateException("Element at ref = " + ref + " doesn't have a parent");
        }
        if (result == null) {
            result = new Element("null", Edit.NAMESPACE);
            result.addContent((Content)info);
        }
        md.addContent((Content)((Element)info.clone()));
        this.setMetadataIntoSession(session, (Element)md.clone(), id);
        return result;
    }

    public synchronized Element deleteAttributeEmbedded(UserSession session, String id, String ref) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        String[] token = ref.split("_");
        String elementId = token[1];
        String attributeName = token[2];
        Element result = new Element("null", Edit.NAMESPACE);
        Element md = AjaxEditUtils.getMetadataFromSession(session, id);
        EditLib editLib = this.dataManager.getEditLib();
        Element el = editLib.findElement(md, elementId);
        if (el != null) {
            Pair<Namespace, String> attInfo = this.parseAttributeName(attributeName, ":", id, md, editLib);
            el.removeAttribute((String)attInfo.two(), (Namespace)attInfo.one());
        }
        this.setMetadataIntoSession(session, (Element)md.clone(), id);
        return result;
    }

    private Pair<Namespace, String> parseAttributeName(String attributeName, String separator, String id, Element md, EditLib editLib) throws Exception {
        Integer indexColon = attributeName.indexOf(separator);
        String localname = attributeName;
        Namespace attrNS = Namespace.NO_NAMESPACE;
        if (indexColon != -1) {
            String prefix = attributeName.substring(0, indexColon);
            localname = attributeName.substring(indexColon + separator.length());
            String schema = this.dataManager.getMetadataSchema(id);
            String namespace = editLib.getNamespace(prefix + ":" + localname, md, this.dataManager.getSchema(schema));
            attrNS = Namespace.getNamespace((String)prefix, (String)namespace);
        }
        return Pair.write((Object)attrNS, (Object)localname);
    }

    public synchronized void swapElementEmbedded(UserSession session, String id, String ref, boolean down) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        Element md = AjaxEditUtils.getMetadataFromSession(session, id);
        EditLib editLib = this.dataManager.getEditLib();
        Element elSwap = editLib.findElement(md, ref);
        if (elSwap == null) {
            throw new IllegalStateException("Element not found at ref = " + ref);
        }
        List list = elSwap.getParentElement().getChildren(elSwap.getName(), elSwap.getNamespace());
        String schemaId = this.dataManager.getMetadataSchema(id);
        MetadataSchema metadataSchema = this.dataManager.getSchema(schemaId);
        SchemaPlugin schemaPlugin = metadataSchema.getSchemaPlugin();
        ArrayList<String> languages = new ArrayList();
        if (schemaPlugin instanceof MultilingualSchemaPlugin) {
            languages = ((MultilingualSchemaPlugin)schemaPlugin).getMetadataLanguages(md);
        }
        int swapIndex = AjaxEditUtils.getElementSwapIndex(list, elSwap);
        int groupSwapIndex = this.getGroupSwapIndex(list, swapIndex, languages);
        if (swapIndex == -1) {
            throw new IllegalStateException("Index not found for element --> " + elSwap);
        }
        if (groupSwapIndex == -1) {
            this.swapElements(elSwap, (Element)list.get(down ? swapIndex + 1 : swapIndex - 1));
        } else {
            for (int i = 0; i < languages.size(); ++i) {
                int currentElementToSwapIndex = groupSwapIndex + i;
                Element topElement = (Element)list.get(currentElementToSwapIndex);
                Element bottomElement = (Element)list.get(currentElementToSwapIndex + languages.size());
                if (down) {
                    this.swapElements(topElement, bottomElement);
                    continue;
                }
                this.swapElements(bottomElement, topElement);
            }
        }
        this.setMetadataIntoSession(session, (Element)md.clone(), id);
    }

    private int getGroupSwapIndex(List<Element> list, int swapIndex, List<String> languages) {
        String elementLanguage = list.get(swapIndex).getAttributeValue("lang", Namespace.XML_NAMESPACE);
        if (list.size() == 1 || languages.size() == 1 || elementLanguage == null) {
            return -1;
        }
        int indexInGroup = languages.indexOf(elementLanguage);
        if (indexInGroup == -1) {
            return swapIndex;
        }
        return swapIndex - indexInGroup;
    }

    private static int getElementSwapIndex(List<Element> list, Element elSwap) {
        int i = -1;
        for (Element element : list) {
            ++i;
            if (element != elSwap) continue;
            return i;
        }
        return i;
    }

    public Element validateMetadataEmbedded(UserSession session, String id, String lang) throws Exception {
        String schema = this.dataManager.getMetadataSchema(id);
        Element realMd = AjaxEditUtils.getMetadataFromSession(session, id);
        Element md = (Element)realMd.clone();
        EditLib editLib = this.dataManager.getEditLib();
        editLib.removeEditingInfo(md);
        editLib.contractElements(md);
        String parentUuid = null;
        md = this.dataManager.updateFixedInfo(schema, Optional.of((Object)Integer.valueOf(id)), null, md, parentUuid, UpdateDatestamp.NO, this.context);
        Processor.processXLink((Element)md, (ServiceContext)this.context);
        return (Element)this.metadataValidator.doValidate(session, schema, id, md, lang, false).one();
    }

    public synchronized boolean addAttribute(String id, String ref, String name, String currVersion) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        Element md = this.xmlSerializer.select(this.context, id);
        if (md == null) {
            return false;
        }
        String schema = this.dataManager.getMetadataSchema(id);
        EditLib editLib = this.dataManager.getEditLib();
        editLib.expandElements(schema, md);
        editLib.enumerateTree(md);
        if (currVersion != null && !editLib.getVersion(id).equals(currVersion)) {
            return false;
        }
        Element el = editLib.findElement(md, ref);
        if (el == null) {
            Log.error((String)"geonetwork.datamanager", (Object)("Element not found at ref = " + ref));
        }
        editLib.removeEditingInfo(md);
        if (el != null) {
            el.setAttribute(new Attribute(name, ""));
        }
        editLib.contractElements(md);
        String parentUuid = null;
        md = this.dataManager.updateFixedInfo(schema, Optional.of((Object)Integer.valueOf(id)), null, md, parentUuid, UpdateDatestamp.NO, this.context);
        String changeDate = null;
        this.xmlSerializer.update(id, md, changeDate, false, null, this.context);
        this.dataManager.indexMetadata(id, true);
        return true;
    }

    public synchronized boolean deleteAttribute(String id, String ref, String name, String currVersion) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        Element md = this.xmlSerializer.select(this.context, id);
        if (md == null) {
            return false;
        }
        String schema = this.dataManager.getMetadataSchema(id);
        EditLib editLib = this.dataManager.getEditLib();
        editLib.expandElements(schema, md);
        editLib.enumerateTree(md);
        if (currVersion != null && !editLib.getVersion(id).equals(currVersion)) {
            return false;
        }
        Element el = editLib.findElement(md, ref);
        if (el == null) {
            throw new IllegalStateException("Element not found at ref = " + ref);
        }
        editLib.removeEditingInfo(md);
        el.removeAttribute(name);
        editLib.contractElements(md);
        String parentUuid = null;
        md = this.dataManager.updateFixedInfo(schema, Optional.of((Object)Integer.valueOf(id)), null, md, parentUuid, UpdateDatestamp.NO, this.context);
        String changeDate = null;
        this.xmlSerializer.update(id, md, changeDate, false, null, this.context);
        this.dataManager.indexMetadata(id, true);
        return true;
    }
}

