/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.management.MalformedObjectNameException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.EmptySlotBatch;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.processing.report.registry.IProcessingReportRegistry;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.events.history.RecordValidationTriggeredEvent;
import org.fao.geonet.inspire.validator.MInspireEtfValidateProcess;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.search.index.BatchOpsMetadataReindexer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="processValidate")
public class ValidateApi {
    private static final int NUMBER_OF_SUBSEQUENT_PROCESS_MBEAN_TO_KEEP = 1;
    @Autowired
    protected ApplicationContext appContext;
    @Autowired
    IProcessingReportRegistry registry;
    @Autowired
    IMetadataValidator validator;
    @Autowired
    AccessManager accessMan;
    @Autowired
    DataManager dataMan;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    MetadataValidationRepository metadataValidationRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    MBeanExporter mBeanExporter;
    @Autowired
    protected XmlSerializer xmlSerializer;
    private final ArrayDeque<SelfNaming> mAnalyseProcesses = new ArrayDeque(1);
    public static final Filter ErrorFinder = new Filter(){

        public boolean matches(Object obj) {
            if (obj instanceof Element) {
                Element element = (Element)obj;
                String name = element.getName();
                if (name.equals("error")) {
                    return true;
                }
                if (name.equals("failed-assert")) {
                    return true;
                }
            }
            return false;
        }
    };

    @PostConstruct
    public void iniMBeansSlidingWindowWithEmptySlot() {
        for (int i = 0; i < 1; ++i) {
            EmptySlotBatch emptySlot = new EmptySlotBatch("batch-etf-inspire", i);
            this.mAnalyseProcesses.addFirst(emptySlot);
            try {
                this.mBeanExporter.registerManagedResource((Object)emptySlot, emptySlot.getObjectName());
                continue;
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
    }

    @Operation(summary="Validate one or more records", description="Update validation status for all records.")
    @RequestMapping(value={"/validate"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Records validated."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport validateRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="") Boolean approved, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, userSession);
            report.setTotalRecords(records.size());
            for (String uuid : records) {
                int loopConditionCount = 0;
                for (AbstractMetadata record : this.metadataRepository.findAllByUuid(uuid)) {
                    boolean isValid;
                    Boolean isMetadataApproved = this.metadataUtils.isMetadataApproved(record.getId());
                    if (approved != null && (!approved.booleanValue() || !isMetadataApproved.booleanValue()) && (approved.booleanValue() || isMetadataApproved.booleanValue())) continue;
                    if (++loopConditionCount > 1) {
                        report.setTotalRecords(report.getNumberOfRecords() + 1);
                    }
                    if (!this.accessMan.canEdit(serviceContext, String.valueOf(record.getId()))) {
                        report.addNotEditableMetadataId(record.getId());
                        continue;
                    }
                    Pair validationPair = this.validator.doValidate(userSession, record.getDataInfo().getSchemaId(), Integer.toString(record.getId()), this.xmlSerializer.select(serviceContext, String.valueOf(record.getId())), serviceContext.getLanguage(), false);
                    boolean bl = isValid = !((Element)validationPair.one()).getDescendants(ErrorFinder).hasNext();
                    if (isValid) {
                        report.addMetadataInfos(record, "Is valid");
                        new RecordValidationTriggeredEvent(Integer.valueOf(record.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), "1").publish((ApplicationContext)applicationContext);
                    } else {
                        report.addMetadataError(record, "(" + record.getUuid() + ") Is invalid");
                        Element schemaTronReport = (Element)validationPair.one();
                        if (schemaTronReport != null) {
                            ArrayList<Namespace> theNSs = new ArrayList<Namespace>();
                            theNSs.add(Namespace.getNamespace((String)"geonet", (String)"http://www.fao.org/geonetwork"));
                            theNSs.add(Namespace.getNamespace((String)"svrl", (String)"http://purl.oclc.org/dsdl/svrl"));
                            List schemaTronReportErrors = Xml.selectNodes((Element)schemaTronReport, (String)("geonet:xsderrors/geonet:error/geonet:message[normalize-space(.) != '']| geonet:schematronerrors/geonet:report[@geonet:required = '" + SchematronRequirement.REQUIRED + "']/svrl:schematron-output/svrl:failed-assert/svrl:text[normalize-space(.) != '']| geonet:schematronerrors/geonet:report[@geonet:required = '" + SchematronRequirement.REQUIRED + "']/geonet:schematronVerificationError[normalize-space(.) != '']"), theNSs);
                            for (Object schemaTronReportError : schemaTronReportErrors) {
                                report.addMetadataError(record, Xml.selectString((Element)((Element)schemaTronReportError), (String)"normalize-space(.)", theNSs));
                            }
                        }
                        new RecordValidationTriggeredEvent(Integer.valueOf(record.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), "0").publish((ApplicationContext)applicationContext);
                    }
                    report.addMetadataId(record.getId());
                    report.incrementProcessedRecords();
                }
                if (loopConditionCount != 0) continue;
                report.incrementNullRecords();
            }
            BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(this.dataMan, report.getMetadata());
            r.process(this.settingManager.getSiteId(), true);
        }
        return report;
    }

    @Operation(summary="Clear validation status of one or more records", description="")
    @RequestMapping(value={"/validate"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Records validation status cleared."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport cleanValidationStatus(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, userSession);
            for (String uuid : records) {
                if (!this.metadataRepository.existsMetadataUuid(uuid)) {
                    report.incrementNullRecords();
                }
                for (AbstractMetadata record : this.metadataRepository.findAllByUuid(uuid)) {
                    if (!this.accessMan.canEdit(serviceContext, String.valueOf(record.getId()))) {
                        report.addNotEditableMetadataId(record.getId());
                        continue;
                    }
                    List validationStatus = this.metadataValidationRepository.findAllById_MetadataId(record.getId());
                    this.metadataValidationRepository.deleteAll((Iterable)validationStatus);
                    report.addMetadataId(record.getId());
                    report.incrementProcessedRecords();
                }
            }
            BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(this.dataMan, report.getMetadata());
            r.process(this.settingManager.getSiteId(), true);
        }
        return report;
    }

    @Operation(summary="Validate one or more records in INSPIRE validator", description="Update validation status for all records.")
    @RequestMapping(value={"/validate/inspire"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Records validated."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity validateRecordsInspire(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Define the encoding of the record to use. By default, ISO19139 are used as is and ISO19115-3 are converted to ISO19139.If mode = csw, a GetRecordById request is used.If mode = any portal id, then a GetRecordById request is used on this portal CSW can only be used on public records as the remote validator request the CSW endpoint.CSW entry point can define additional CSW post processing (if encoding need adjustments to cope with INSPIRE requirements). See https://github.com/geonetwork/core-geonetwork/pull/4493.", required=false) @RequestParam(required=false) String mode, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        MInspireEtfValidateProcess registredMAnalyseProcess = this.getRegistredMInspireEtfValidateProcess(serviceContext);
        registredMAnalyseProcess.deleteAll();
        UserSession userSession = ApiUtils.getUserSession(session);
        Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, userSession);
        registredMAnalyseProcess.processMetadata(records, mode);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private MInspireEtfValidateProcess getRegistredMInspireEtfValidateProcess(ServiceContext serviceContext) {
        String URL2 = this.settingManager.getValue("system/inspire/remotevalidation/url");
        String URL_QUERY = this.settingManager.getValue("system/inspire/remotevalidation/urlquery");
        if (StringUtils.isEmpty((String)URL_QUERY)) {
            URL_QUERY = URL2;
        }
        MInspireEtfValidateProcess mAnalyseProcess = new MInspireEtfValidateProcess(this.settingManager.getSiteId(), URL2, URL_QUERY, serviceContext, this.appContext);
        this.mBeanExporter.registerManagedResource((Object)mAnalyseProcess, mAnalyseProcess.getObjectName());
        try {
            this.mBeanExporter.unregisterManagedResource(this.mAnalyseProcesses.removeLast().getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        this.mAnalyseProcesses.addFirst(mAnalyseProcess);
        return mAnalyseProcess;
    }
}

