/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.mapservers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.CheckReturnValue;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.fao.geonet.Constants;
import org.fao.geonet.api.mapservers.GeoFile;
import org.fao.geonet.csw.common.util.Xml;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.nio.PathHttpEntity;
import org.jdom.Element;
import org.springframework.http.client.ClientHttpResponse;

public class GeoServerRest {
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String LOGGER_NAME = "geonetwork.geoserver.rest";
    private final String password;
    private final String username;
    private final String restUrl;
    private final String baseCatalogueUrl;
    private final String nodeUrl;
    private final String defaultWorkspace;
    private String response = "";
    private final boolean pushStyleInWorkspace;
    private int status;
    private final GeonetHttpRequestFactory factory;
    private String report = "";
    private String errorCode;

    public GeoServerRest(GeonetHttpRequestFactory factory, String url, String username, String password, String defaultns, String baseCatalogueUrl, String nodeUrl, boolean pushStyleInWorkspace) {
        this.restUrl = url;
        this.username = username;
        this.password = password;
        this.baseCatalogueUrl = baseCatalogueUrl;
        this.nodeUrl = nodeUrl;
        this.pushStyleInWorkspace = pushStyleInWorkspace;
        this.factory = factory;
        Log.createLogger((String)LOGGER_NAME);
        this.defaultWorkspace = defaultns;
    }

    public String getResponse() {
        return this.response;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public boolean getLayer(String layer) throws IOException {
        return this.getLayer(this.getDefaultWorkspace(), layer);
    }

    public boolean getLayer(String ws, String layer) throws IOException {
        int status;
        Object url = "/layers/";
        if (!ws.isEmpty()) {
            url = (String)url + ws + ":";
        }
        return (status = this.sendREST(METHOD_GET, (String)url + layer + ".xml?quietOnNotFound=true", null, null, null, true)) == 200;
    }

    public String getLayerInfo(String layer) throws IOException {
        if (this.getLayer(layer)) {
            return this.getResponse();
        }
        return null;
    }

    public boolean deleteLayer(String layer) throws IOException {
        return this.deleteLayer(this.getDefaultWorkspace(), layer);
    }

    public boolean deleteLayer(String ws, String layer) throws IOException {
        int status;
        Object url = "/layers/";
        if (!ws.isEmpty()) {
            url = (String)url + ws + ":";
        }
        return (status = this.sendREST(METHOD_DELETE, (String)url + layer, null, null, null, true)) == 200;
    }

    public boolean createCoverage(String ws, String cs, Path f, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        String contentType = "image/tiff";
        if (f.getFileName().toString().toLowerCase().endsWith(".zip")) {
            contentType = "application/zip";
        }
        int status = this.sendREST(METHOD_PUT, "/workspaces/" + ws + "/coveragestores/" + cs + "/file.geotiff", null, f, contentType, false);
        this.createCoverageForStore(ws, cs, null, metadataUuid, metadataTitle, metadataAbstract);
        return status == 201;
    }

    public boolean createCoverage(String ws, String cs, String file, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        String contentType = "image/tiff";
        String extension = "geotiff";
        if (GeoFile.fileIsECW(file).booleanValue()) {
            contentType = "image/ecw";
            extension = "ecw";
        }
        String type = "file";
        if (file.toLowerCase().endsWith(".zip")) {
            contentType = "application/zip";
        }
        if (file.startsWith("http://")) {
            type = "url";
        } else if (file.startsWith("file://")) {
            type = "external";
        }
        int status = this.sendREST(METHOD_PUT, "/workspaces/" + ws + "/coveragestores/" + cs + "/" + type + "." + extension, file, null, contentType, false);
        this.createCoverageForStore(ws, cs, file, metadataUuid, metadataTitle, metadataAbstract);
        return status == 201;
    }

    private void createCoverageForStore(String ws, String cs, String file, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        String xml = "<coverage><name>" + cs + "</name><title>" + (metadataTitle != null ? metadataTitle : cs) + "</title><enabled>true</enabled>" + (String)(file != null ? "<file>" + file + "</file>" : "") + "<metadataLinks><metadataLink><type>text/xml</type><metadataType>ISO19115:2003</metadataType><content>" + this.baseCatalogueUrl + "/csw?SERVICE=CSW&amp;VERSION=2.0.2&amp;REQUEST=GetRecordById&amp;outputSchema=http://www.isotc211.org/2005/gmd&amp;ID=" + metadataUuid + "</content></metadataLink><metadataLink><type>text/html</type><metadataType>TC211</metadataType><content>" + this.baseCatalogueUrl + "/csw?SERVICE=CSW&amp;VERSION=2.0.2&amp;REQUEST=GetRecordById&amp;outputSchema=http://www.isotc211.org/2005/gmd&amp;ID=" + metadataUuid + "</content></metadataLink><metadataLink><type>text/html</type><metadataType>TC211</metadataType><content>" + this.nodeUrl + "api/records/" + metadataUuid + "</content></metadataLink></metadataLinks></coverage>";
        int statusCoverage = this.sendREST(METHOD_POST, "/workspaces/" + ws + "/coveragestores/" + cs + "/coverages.xml", xml, null, "text/xml", false);
        this.checkResponseCode(statusCoverage);
    }

    public boolean createCoverage(String cs, Path f, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        return this.createCoverage(this.getDefaultWorkspace(), cs, f, metadataUuid, metadataTitle, metadataAbstract);
    }

    public boolean createCoverage(String cs, String f, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        return this.createCoverage(this.getDefaultWorkspace(), cs, f, metadataUuid, metadataTitle, metadataAbstract);
    }

    public boolean updateCoverage(String ws, String ds, Path f, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        return this.createCoverage(ws, ds, f, metadataUuid, metadataTitle, metadataAbstract);
    }

    public boolean updateCoverage(String ds, Path f, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        return this.createCoverage(this.getDefaultWorkspace(), ds, f, metadataUuid, metadataTitle, metadataAbstract);
    }

    public boolean deleteCoverage(String ws, String cs, String c) throws IOException {
        int status = this.sendREST(METHOD_DELETE, "/workspaces/" + ws + "/coveragestores/" + cs + "/coverages/" + c, null, null, null, true);
        return status == 200;
    }

    public boolean deleteCoverage(String cs, String c) throws IOException {
        return this.deleteCoverage(this.getDefaultWorkspace(), cs, c);
    }

    public boolean createDatastore(String ws, String ds, Path f, String format) throws IOException {
        String contentType = "application/x-sqlite3";
        if (f.getFileName().toString().toLowerCase().endsWith(".zip")) {
            contentType = "application/zip";
        }
        Log.debug((String)"geonetwork.geopublisher", (Object)("Creating datastore " + ds + " in workspace " + ws + " from path " + f.toString() + " with format " + format + " & Content-Type " + contentType));
        int status = this.sendREST(METHOD_PUT, "/workspaces/" + ws + "/datastores/" + ds + "/file." + format, null, f, contentType, false);
        return status == 201;
    }

    public boolean createDatastore(String ws, String ds, String file) throws IOException {
        String type = "";
        String extension = file.substring(file.lastIndexOf(46));
        if (file.startsWith("http://")) {
            type = "url";
        } else if (file.startsWith("file://")) {
            type = "external";
        }
        boolean isZip = ".zip".equals(extension);
        Log.debug((String)"geonetwork.geopublisher", (Object)("Creating datastore " + ds + " in workspace " + ws + " from file " + file));
        int status = this.sendREST(METHOD_PUT, "/workspaces/" + ws + "/datastores/" + ds + "/" + type + (isZip ? ".shp" : extension), file, null, isZip ? "application/zip" : "text/plain", false);
        return status == 201;
    }

    public boolean createDatastore(String ds, Path f, String fo) throws IOException {
        return this.createDatastore(this.getDefaultWorkspace(), ds, f, fo);
    }

    public boolean createDatastore(String ds, String file) throws IOException {
        return this.createDatastore(this.getDefaultWorkspace(), ds, file);
    }

    public boolean deleteDatastore(String ws, String ds) throws IOException {
        int status = this.sendREST(METHOD_DELETE, "/workspaces/" + ws + "/datastores/" + ds, null, null, null, true);
        return status == 200;
    }

    public boolean deleteDatastore(String ds) throws IOException {
        return this.deleteDatastore(this.getDefaultWorkspace(), ds);
    }

    public boolean deleteCoverageStore(String ws, String cs) throws IOException {
        int status = this.sendREST(METHOD_DELETE, "/workspaces/" + ws + "/coveragestores/" + cs, null, null, null, true);
        return status == 200;
    }

    public boolean deleteCoverageStore(String ds) throws IOException {
        return this.deleteCoverageStore(this.getDefaultWorkspace(), ds);
    }

    public boolean deleteFeatureType(String ws, String ds, String ft) throws IOException {
        int status = this.sendREST(METHOD_DELETE, "/workspaces/" + ws + "/datastores/" + ds + "/featuretypes/" + ft, null, null, null, true);
        return status == 200;
    }

    public boolean deleteFeatureType(String ds, String ft) throws IOException {
        return this.deleteFeatureType(this.getDefaultWorkspace(), ds, ft);
    }

    public boolean createStyle(String layer) {
        return this.createStyle(this.getDefaultWorkspace(), layer, "");
    }

    public boolean createStyle(String ws, String layer) {
        return this.createStyle(ws, layer, "");
    }

    public boolean createStyle(String ws, String layer, String sldbody) {
        block12: {
            try {
                String info;
                Object url = "/styles/";
                if (this.pushStyleInWorkspace) {
                    url = (String)url + ws + ":";
                }
                url = (String)url + layer + "_style?quietOnNotFound=true";
                Log.debug((String)"geonetwork.geopublisher", (Object)("Checking if a style named " + layer + "_style already exists in workspace " + ws));
                int status = this.sendREST(METHOD_GET, (String)url, null, null, null, true);
                this.checkResponseCode(status);
                String body = "<style><name>" + layer + "_style</name><filename>" + layer + ".sld</filename></style>";
                url = "/styles";
                if (this.pushStyleInWorkspace) {
                    url = "/workspaces/" + ws + "/styles";
                }
                if (status != 200) {
                    Log.debug((String)"geonetwork.geopublisher", (Object)("Creating style " + layer + "_style for layer " + layer));
                    status = this.sendREST(METHOD_POST, (String)url, body, null, "text/xml", true);
                    this.checkResponseCode(status);
                }
                if (!sldbody.isEmpty()) {
                    if (Log.isDebugEnabled((String)"geonetwork.geopublisher")) {
                        Log.debug((String)"geonetwork.geopublisher", (Object)"GeoFile contains an sld, trying to use it");
                    }
                    if ((status = this.sendREST(METHOD_PUT, (String)url + "/" + layer + "_style", sldbody, null, "application/vnd.ogc.sld+xml", true)) != 200) {
                        Log.warning((String)"geonetwork.geopublisher", (Object)"The sld file was probably not valid, falling back to default");
                    }
                }
                if ((sldbody.isEmpty() || !sldbody.isEmpty() && status != 200) && (info = this.getLayerInfo(layer)) != null) {
                    Element layerProperties = Xml.loadString((String)info, (boolean)false);
                    String styleName = layerProperties.getChild("defaultStyle").getChild("name").getText();
                    Log.debug((String)"geonetwork.geopublisher", (Object)("Getting default style for " + styleName + " to apply to layer " + layer + " in workspace " + ws));
                    status = this.sendREST(METHOD_GET, "/styles/" + styleName + ".sld?quietOnNotFound=true", null, null, null, true);
                    status = this.sendREST(METHOD_PUT, (String)url + "/" + layer + "_style", this.getResponse(), null, "application/vnd.ogc.sld+xml", true);
                }
                this.checkResponseCode(status);
                Log.debug((String)"geonetwork.geopublisher", (Object)"Adding enable flag to layer");
                body = "<layer><defaultStyle><name>" + layer + "_style</name>";
                if (this.pushStyleInWorkspace) {
                    body = body + "<workspace>" + ws + "</workspace>";
                }
                body = body + "</defaultStyle><enabled>true</enabled></layer>";
                url = "/layers/";
                if (!ws.isEmpty()) {
                    url = (String)url + ws + ":";
                }
                status = this.sendREST(METHOD_PUT, (String)url + layer, body, null, "text/xml", true);
                this.checkResponseCode(status);
            }
            catch (RuntimeException e) {
                Log.error((String)"geonetwork.geopublisher", (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                if (!Log.isDebugEnabled((String)LOGGER_NAME)) break block12;
                Log.debug((String)LOGGER_NAME, (Object)("Failed to create style for layer: " + layer + " in workspace " + ws + ", error is: " + e.getMessage()));
            }
        }
        return this.status == 200;
    }

    private void checkResponseCode(int status2) {
        if (status2 > 399) {
            Log.warning((String)"geonetwork.geopublisher", (Object)("Warning a bad response code to message was returned:" + status2));
            if (!this.response.isEmpty()) {
                Log.warning((String)"geonetwork.geopublisher", (Object)("Response content:" + this.response));
                this.setReport(this.response);
            }
        }
    }

    public boolean createDatabaseDatastore(String ds, String host, String port, String db, String user, String pwd, String dbType, String ns) throws IOException {
        return this.createDatabaseDatastore(this.getDefaultWorkspace(), ds, host, port, db, user, pwd, dbType, ns);
    }

    public boolean createDatabaseDatastore(String ws, String ds, String host, String port, String db, String user, String pwd, String dbType, String ns) throws IOException {
        String xml = "<dataStore><name>" + ds + "</name><enabled>true</enabled><connectionParameters><host>" + host + "</host><port>" + port + "</port><database>" + db + "</database><user>" + user + "</user><passwd>" + pwd + "</passwd><dbtype>" + dbType + "</dbtype><namespace>" + ns + "</namespace></connectionParameters></dataStore>";
        this.status = this.sendREST(METHOD_POST, "/workspaces/" + ws + "/datastores", xml, null, "text/xml", true);
        return 201 == this.status;
    }

    public boolean createFeatureType(String ds, String ft, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        return this.createFeatureType(this.getDefaultWorkspace(), ds, ft, metadataUuid, metadataTitle, metadataAbstract);
    }

    public boolean createFeatureType(String ws, String ds, String ft, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        String xml = "<featureType><name>" + ft + "</name><title>" + ft + "</title></featureType>";
        String url = "/workspaces/" + ws + "/datastores/" + ds + "/featuretypes";
        Log.debug((String)"geonetwork.geopublisher", (Object)("Checking if a featuretype named " + ft + " already exists in workspace " + ws + ", datastore " + ds));
        this.status = this.sendREST(METHOD_GET, url + "/" + ft, null, null, null, true);
        if (this.status != 200) {
            Log.debug((String)"geonetwork.geopublisher", (Object)("Creating featuretype " + ft + " in workspace " + ws + " within datastore " + ds));
            this.status = this.sendREST(METHOD_POST, url, xml, null, "text/xml", true);
            this.checkResponseCode(this.status);
        }
        xml = "<featureType><title>" + (metadataTitle != null ? metadataTitle : ft) + "</title><abstract>" + (metadataAbstract != null ? metadataAbstract : ft) + "</abstract><enabled>true</enabled><metadataLinks><metadataLink><type>text/xml</type><metadataType>ISO19115:2003</metadataType><content>" + this.baseCatalogueUrl + "/csw?SERVICE=CSW&amp;VERSION=2.0.2&amp;REQUEST=GetRecordById&amp;outputSchema=http://www.isotc211.org/2005/gmd&amp;ID=" + metadataUuid + "</content></metadataLink><metadataLink><type>text/xml</type><metadataType>TC211</metadataType><content>" + this.baseCatalogueUrl + "/csw?SERVICE=CSW&amp;VERSION=2.0.2&amp;REQUEST=GetRecordById&amp;outputSchema=http://www.isotc211.org/2005/gmd&amp;ID=" + metadataUuid + "</content></metadataLink><metadataLink><type>text/html</type><metadataType>TC211</metadataType><content>" + this.nodeUrl + "api/records/" + metadataUuid + "</content></metadataLink></metadataLinks></featureType>";
        this.status = this.sendREST(METHOD_PUT, url + "/" + ft, xml, null, "text/xml", true);
        return 201 == this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public int sendREST(String method, String urlParams, String postData, Path file, String contentType, Boolean saveResponse) throws IOException {
        StringEntity entity;
        HttpPut m;
        this.response = "";
        String url = this.restUrl + urlParams;
        if (Log.isDebugEnabled((String)LOGGER_NAME)) {
            Log.debug((String)LOGGER_NAME, (Object)("url:" + url));
            Log.debug((String)LOGGER_NAME, (Object)("method:" + method));
            if (postData != null) {
                Log.debug((String)LOGGER_NAME, (Object)("postData:" + postData));
            }
        }
        if (method.equals(METHOD_PUT)) {
            m = new HttpPut(url);
            if (file != null) {
                m.setEntity((HttpEntity)new PathHttpEntity(file, ContentType.create((String)contentType, (String)Constants.ENCODING)));
            }
            if (postData != null) {
                entity = new StringEntity(postData, ContentType.create((String)contentType, (String)Constants.ENCODING));
                m.setEntity((HttpEntity)entity);
            }
        } else if (method.equals(METHOD_DELETE)) {
            m = new HttpDelete(url);
        } else if (method.equals(METHOD_POST)) {
            m = new HttpPost(url);
            if (postData != null) {
                entity = new StringEntity(postData, ContentType.create((String)contentType, (String)Constants.ENCODING));
                ((HttpPost)m).setEntity((HttpEntity)entity);
            }
        } else {
            m = new HttpGet(url);
        }
        if (contentType != null && !"".equals(contentType)) {
            m.setHeader("Content-type", contentType);
        }
        m.setConfig(RequestConfig.custom().setAuthenticationEnabled(true).build());
        try {
            m.addHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(this.username, this.password), (HttpRequest)m));
        }
        catch (AuthenticationException a) {
            Log.warning((String)LOGGER_NAME, (Object)("Failed to add the authentication Header, error is: " + a.getMessage()));
        }
        try (ClientHttpResponse httpResponse = this.factory.execute((HttpUriRequest)m, (Credentials)new UsernamePasswordCredentials(this.username, this.password), AuthScope.ANY);){
            this.status = httpResponse.getRawStatusCode();
            if (Log.isDebugEnabled((String)LOGGER_NAME)) {
                Log.debug((String)LOGGER_NAME, (Object)("status:" + this.status));
            }
            if (saveResponse.booleanValue()) {
                this.response = IOUtils.toString((InputStream)httpResponse.getBody());
            }
        }
        return this.status;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

