/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.mapservers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.ZipUtil;

public class GeoFile
implements Closeable {
    private FileSystem zipFile = null;
    private Path file = null;
    private String format = null;
    private boolean _containsSld = false;
    private String _sldBody;

    public GeoFile(Path f) throws IOException {
        this.file = f;
        try {
            this.zipFile = FilenameUtils.getExtension((String)this.file.getFileName().toString()).equalsIgnoreCase("zip") ? ZipUtil.openZipFs((Path)this.file) : null;
        }
        catch (IOException | URISyntaxException e) {
            this.zipFile = null;
        }
    }

    private static String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static Boolean fileIsGeotif(String fileName) {
        String extension = GeoFile.getExtension(fileName);
        return extension.equalsIgnoreCase("tif") || extension.equalsIgnoreCase("tiff") || extension.equalsIgnoreCase("geotif") || extension.equalsIgnoreCase("geotiff");
    }

    public static Boolean fileIsECW(String fileName) {
        String extension = GeoFile.getExtension(fileName);
        return extension.equalsIgnoreCase("ecw");
    }

    public static Boolean fileIsRASTER(String fileName) {
        return GeoFile.fileIsGeotif(fileName) != false || GeoFile.fileIsECW(fileName) != false;
    }

    public Collection<String> getVectorLayers(final boolean onlyOneFileAllowed) throws IOException {
        final LinkedList<String> layers = new LinkedList<String>();
        if (this.zipFile != null) {
            for (Path path : this.zipFile.getRootDirectories()) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public FileVisitResult visitFile(Path vfile, BasicFileAttributes attrs) throws IOException {
                        String base;
                        String fileName = vfile.getFileName().toString();
                        if (GeoFile.this.fileIsShp(fileName).booleanValue()) {
                            GeoFile.this.format = "shp";
                            base = GeoFile.this.getBase(fileName);
                            if (onlyOneFileAllowed) {
                                if (layers.size() > 1) {
                                    throw new IllegalArgumentException("Only one shapefile per zip is allowed. " + layers.size() + " shapefiles found.");
                                }
                                if (!base.equals(GeoFile.this.getBase(GeoFile.this.file.getFileName().toString()))) throw new IllegalArgumentException("Shapefile name (" + base + ") is not equal to ZIP file name (" + GeoFile.this.file.getFileName() + ").");
                                layers.add(base);
                            } else {
                                layers.add(base);
                            }
                        }
                        if (GeoFile.this.fileIsGpkg(fileName).booleanValue()) {
                            GeoFile.this.format = "gpkg";
                            base = GeoFile.this.getBase(fileName);
                            if (onlyOneFileAllowed) {
                                if (layers.size() > 1) {
                                    throw new IllegalArgumentException("Only one geopackage per zip is allowed. " + layers.size() + " geopackage found.");
                                }
                                if (!base.equals(GeoFile.this.getBase(GeoFile.this.file.getFileName().toString()))) throw new IllegalArgumentException("Geopackage name (" + base + ") is not equal to ZIP file name (" + GeoFile.this.file.getFileName() + ").");
                                layers.add(base);
                            } else {
                                layers.add(base);
                            }
                        }
                        if (!GeoFile.this.fileIsSld(fileName).booleanValue()) return FileVisitResult.CONTINUE;
                        GeoFile.this._containsSld = true;
                        GeoFile.this._sldBody = fileName;
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            if (this._containsSld) {
                String line;
                ZipFile zf = new ZipFile(new File(this.file.toString()));
                InputStream is = zf.getInputStream(zf.getEntry(this._sldBody));
                BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                this._sldBody = "";
                while ((line = br.readLine()) != null) {
                    this._sldBody = this._sldBody + line;
                }
                br.close();
                is.close();
                zf.close();
            }
        } else {
            String fileName = this.file.getFileName().toString();
            if (this.fileIsGpkg(fileName).booleanValue()) {
                this.format = "gpkg";
                layers.add(this.getBase(fileName));
            }
        }
        return layers;
    }

    public Collection<String> getRasterLayers() throws IOException {
        final LinkedList<String> layers = new LinkedList<String>();
        if (this.zipFile != null) {
            for (Path path : this.zipFile.getRootDirectories()) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fileName = file.getFileName().toString();
                        if (GeoFile.fileIsGeotif(fileName).booleanValue()) {
                            GeoFile.this.format = "tiff";
                            layers.add(GeoFile.this.getBase(fileName));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        } else {
            String fileName = this.file.getFileName().toString();
            if (GeoFile.fileIsGeotif(fileName).booleanValue()) {
                this.format = "tiff";
                layers.add(this.getBase(fileName));
            }
        }
        return layers;
    }

    private String getBase(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    private Boolean fileIsShp(String fileName) {
        String extension = GeoFile.getExtension(fileName);
        return extension.equalsIgnoreCase("shp");
    }

    private Boolean fileIsGpkg(String fileName) {
        String extension = GeoFile.getExtension(fileName);
        return extension.equalsIgnoreCase("gpkg");
    }

    private Boolean fileIsSld(String fileName) {
        String extension = GeoFile.getExtension(fileName);
        return extension.equalsIgnoreCase("sld");
    }

    public Boolean containsSld() {
        return this._containsSld;
    }

    public String getSld() {
        return this._sldBody;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void close() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }
}

