/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseGeonetParams;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.XmlRequest;

public abstract class BaseGeoNetworkHarvester<P extends BaseGeonetParams> {
    protected final AtomicBoolean cancelMonitor;
    protected final List<HarvestError> errors;
    protected Logger log;
    protected P params;
    protected ServiceContext context;

    public BaseGeoNetworkHarvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, P params, List<HarvestError> errors) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
    }

    protected void updateSources(SortedSet<RecordInfo> records, Map<String, Source> remoteSources) throws MalformedURLException {
        this.log.info("Aligning source logos from for : " + ((AbstractParams)this.params).getName());
        HashSet<String> sources = new HashSet<String>();
        for (RecordInfo ri : records) {
            sources.add(ri.source);
        }
        String siteId = ((SettingManager)this.context.getBean(SettingManager.class)).getSiteId();
        Resources resources = (Resources)this.context.getBean(Resources.class);
        for (String sourceUuid : sources) {
            if (siteId.equals(sourceUuid)) continue;
            Source source = remoteSources.get(sourceUuid);
            if (source != null) {
                this.retrieveLogo(this.context, resources, ((BaseGeonetParams)this.params).host, sourceUuid);
            } else {
                String sourceName = "(unknown)";
                source = new Source(sourceUuid, sourceName, new HashMap(), SourceType.harvester);
                resources.copyUnknownLogo(this.context, sourceUuid);
            }
            ((SourceRepository)this.context.getBean(SourceRepository.class)).save((Object)source);
        }
    }

    protected void retrieveLogo(ServiceContext context, Resources resources, String url, String uuid) throws MalformedURLException {
        String logo = uuid + ".gif";
        Object baseUrl = url;
        if (!new URL((String)baseUrl).getPath().endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        XmlRequest req = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL((String)baseUrl));
        Lib.net.setupProxy(context, req);
        req.setAddress(req.getAddress() + "images/logos/" + logo);
        Path logoDir = resources.locateLogosDir(context);
        try {
            resources.createImageFromReq(context, logoDir, logo, req);
        }
        catch (IOException e) {
            context.warning("Cannot retrieve logo file from : " + url);
            context.warning("  (C) Logo  : " + logo);
            context.warning("  (C) Excep : " + e.getMessage());
            resources.copyUnknownLogo(context, uuid);
        }
    }
}

