/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jcs.access.exception.InvalidArgumentException;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.springframework.util.StringUtils;

public class OIDCConfiguration
implements SecurityProviderConfiguration {
    private String userNameAttribute = "email";
    private String organizationProperty = "organization";
    private String groupPermissionSeparator = ":";
    private String idTokenRoleLocation = "groups";
    private Map<String, String> roleConverter = new HashMap<String, String>();
    private String minimumProfile = "Guest";
    private boolean updateProfile = true;
    private boolean updateGroup = true;
    private boolean logSensitiveInformation = false;
    public String roleConverterString = null;
    private final ClientConfig clientconfig = new ClientConfig();
    private final ClientConfig serviceAccountConfig = new ClientConfig();
    private SecurityProviderConfiguration.LoginType loginType = SecurityProviderConfiguration.LoginType.LINK;

    public ClientConfig getClientConfig() {
        return this.clientconfig;
    }

    public ClientConfig getServiceAccountConfig() {
        return this.serviceAccountConfig;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public boolean isLogSensitiveInformation() {
        return this.logSensitiveInformation;
    }

    public void setLogSensitiveInformation(boolean logSensitiveInformation) {
        this.logSensitiveInformation = logSensitiveInformation;
    }

    public String getOrganizationProperty() {
        return this.organizationProperty;
    }

    public void setOrganizationProperty(String organizationProperty) {
        this.organizationProperty = organizationProperty;
    }

    public String getGroupPermissionSeparator() {
        return this.groupPermissionSeparator;
    }

    public void setGroupPermissionSeparator(String groupPermissionSeparator) {
        this.groupPermissionSeparator = groupPermissionSeparator;
    }

    public String getIdTokenRoleLocation() {
        return this.idTokenRoleLocation;
    }

    public void setIdTokenRoleLocation(String idTokenRoleLocation) {
        this.idTokenRoleLocation = idTokenRoleLocation;
    }

    public Map<String, String> getRoleConverter() {
        return this.roleConverter;
    }

    public void setRoleConverter(Map<String, String> roleConverter) {
        this.roleConverter = roleConverter;
    }

    public Profile getMinimumProfile() {
        return Profile.findProfileIgnoreCase((String)this.minimumProfile);
    }

    public void setMinimumProfile(String minimumProfile) {
        this.minimumProfile = minimumProfile;
    }

    @Override
    public String getLoginType() {
        return this.loginType.toString();
    }

    public void setLoginType(String loginType) throws Exception {
        this.loginType = SecurityProviderConfiguration.LoginType.parse(loginType);
        if (!this.loginType.equals((Object)SecurityProviderConfiguration.LoginType.AUTOLOGIN) && !this.loginType.equals((Object)SecurityProviderConfiguration.LoginType.LINK)) {
            throw new InvalidArgumentException("Configuration error - login type should only be LINK or AUTOLOGIN");
        }
    }

    @Override
    public String getSecurityProvider() {
        return "OIDC";
    }

    @Override
    public boolean isUserProfileUpdateEnabled() {
        return !this.updateProfile;
    }

    @Override
    public boolean isUserGroupUpdateEnabled() {
        return !this.updateGroup;
    }

    public boolean isUpdateProfile() {
        return this.updateProfile;
    }

    public void setUpdateProfile(boolean updateProfile) {
        this.updateProfile = updateProfile;
    }

    public boolean isUpdateGroup() {
        return this.updateGroup;
    }

    public void setUpdateGroup(boolean updateGroup) {
        this.updateGroup = updateGroup;
    }

    public void updateRoleConverterString(String serialized) {
        String[] items;
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.hasText((String)serialized)) {
            return;
        }
        serialized = serialized.trim();
        for (String item : items = serialized.split(",")) {
            String[] keyValue = item.split("=");
            result.put(keyValue[0].trim(), keyValue[1].trim());
        }
        this.roleConverter = result;
    }

    public void setRoleConverterString(String roleConverterString) {
        this.roleConverterString = roleConverterString;
        this.updateRoleConverterString(roleConverterString);
    }

    public String toString() {
        Object result = "OIDC CONFIG: \n";
        result = (String)result + "      idTokenRoleLocation=" + this.idTokenRoleLocation + "\n";
        result = (String)result + "      updateGroup=" + this.updateGroup + "\n";
        result = (String)result + "      updateProfile=" + this.updateProfile + "\n";
        result = (String)result + "      scopes=" + this.getClientConfig().getScopes() + "\n";
        if (this.roleConverter != null && !this.roleConverter.isEmpty()) {
            result = (String)result + "      roleConverter: \n";
            for (Map.Entry<String, String> role : this.roleConverter.entrySet()) {
                result = (String)result + "            + " + role.getKey() + " -> " + role.getValue();
            }
        }
        return result;
    }

    public static class ClientConfig {
        private String scopes = null;
        private String clientId;
        private String clientSecret;
        private boolean enabled = true;

        public String getScopes() {
            return this.scopes;
        }

        public void setScopes(String scopes) {
            this.scopes = scopes;
        }

        public List<String> getScopeSet() {
            if (!StringUtils.hasText((String)this.getScopes())) {
                return null;
            }
            return Arrays.asList(this.getScopes().split(" "));
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

