/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkExtension;
import org.fao.geonet.kernel.schema.ExportablePlugin;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class ExportFormat
implements GeonetworkExtension {
    public static Iterable<Pair<String, String>> getFormats(ServiceContext context, AbstractMetadata metadata) throws Exception {
        String schema = metadata.getDataInfo().getSchemaId();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = gc.getBean(DataManager.class);
        MetadataSchema metadataSchema = dm.getSchema(schema);
        SchemaPlugin schemaPlugin = metadataSchema.getSchemaPlugin();
        if (schemaPlugin instanceof ExportablePlugin) {
            Map allFormats = ((ExportablePlugin)schemaPlugin).getExportFormats();
            HashSet<Pair<String, String>> allExports = new HashSet<Pair<String, String>>();
            for (Map.Entry entry : allFormats.entrySet()) {
                String xslFileName = (String)entry.getKey();
                String outputFileName = (String)entry.getValue();
                Path path = metadataSchema.getSchemaDir().resolve(xslFileName);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String outputData = ExportFormat.formatData(context, metadata, true, path);
                    allExports.add((Pair<String, String>)Pair.read((Object)outputFileName, (Object)outputData));
                    continue;
                }
                if (!Log.isDebugEnabled((String)"geonetwork.mef")) continue;
                Log.debug((String)"geonetwork.mef", (Object)String.format("Exporting MEF file for '%s' schema plugin formats. File '%s' not found", metadataSchema.getName(), path.getFileName()));
            }
            return allExports;
        }
        return Collections.emptyList();
    }

    public static String formatData(ServiceContext context, AbstractMetadata metadata, boolean transform, Path stylePath) throws Exception {
        Object data;
        Element md = context.getBean(DataManager.class).getMetadata(context, "" + metadata.getId(), false, false, true);
        md.removeChild("info", Edit.NAMESPACE);
        if (transform) {
            md = Xml.transform((Element)md, (Path)stylePath);
        }
        if (!((String)(data = Xml.getString((Element)md))).startsWith("<?xml")) {
            data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n" + (String)data;
        }
        return data;
    }
}

