/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.UriLocator;

public class SaasUriLocator
implements UriLocator {
    private static final Logger LOG = LoggerFactory.getLogger(SaasUriLocator.class);
    public static final String ALIAS = "saasUri";

    @Override
    public boolean accept(String url) {
        if (url == null) {
            return false;
        }
        String extension = FilenameUtils.getExtension((String)url);
        if ("".equals(extension) || "scss".equals(extension)) {
            boolean result;
            boolean bl = result = this.getScssFile(url) != null;
            if (!result) {
                LOG.debug("Possible scss file not found {}", (Object)url);
            }
            return result;
        }
        return false;
    }

    File getScssFile(String url) {
        File result;
        if (url == null) {
            return null;
        }
        if (url.startsWith("file:")) {
            url = url.replace("file:", "");
        }
        if ((result = new File(url)).isFile()) {
            return result;
        }
        result = new File(url + ".scss");
        if (result.isFile()) {
            return result;
        }
        if (!url.endsWith(".scss") && !url.endsWith("/")) {
            int lastSlash = url.lastIndexOf(47) + 1;
            Object cleanUrl = url.substring(0, lastSlash);
            cleanUrl = (String)cleanUrl + "_" + url.substring(lastSlash, url.length()) + ".scss";
            result = new File((String)cleanUrl);
        } else {
            result = new File(url);
        }
        if (result.isFile()) {
            return result;
        }
        return null;
    }

    @Override
    public InputStream locate(String uri) throws IOException {
        Validate.notNull((Object)uri, (String)"URI cannot be NULL!", (Object[])new Object[0]);
        LOG.debug("loading  scss file: {}", (Object)uri);
        return new FileInputStream(this.getScssFile(uri));
    }
}

