/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.transformer.TransformerKey;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CompoundIterator;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultTransformerRegistry
extends AbstractMap<TransformerKey, Transformer>
implements TransformerRegistry<TransformerKey> {
    private static final long serialVersionUID = 1L;
    private Map<TransformerKey, Transformer> dynamicMap;
    private Map<TransformerKey, Transformer> staticMap;
    private Map<TransformerKey, TransformerKey> aliasMap;
    private final CamelContext context;
    private int maxCacheSize;

    public DefaultTransformerRegistry(CamelContext context) throws Exception {
        this(context, new ArrayList<TransformerDefinition>());
    }

    public DefaultTransformerRegistry(CamelContext context, List<TransformerDefinition> definitions) throws Exception {
        this.maxCacheSize = CamelContextHelper.getMaximumTransformerCacheSize(context);
        this.dynamicMap = LRUCacheFactory.newLRUCache(this.maxCacheSize, this.maxCacheSize, false);
        this.staticMap = new ConcurrentHashMap<TransformerKey, Transformer>();
        this.aliasMap = new ConcurrentHashMap<TransformerKey, TransformerKey>();
        this.context = context;
        for (TransformerDefinition def : definitions) {
            Transformer transformer = def.createTransformer(context);
            context.addService(transformer);
            this.put(this.createKey(def), transformer);
        }
    }

    @Override
    public Transformer resolveTransformer(TransformerKey key) {
        if (ObjectHelper.isEmpty(key.getScheme()) && key.getTo() == null) {
            return null;
        }
        Transformer answer = this.get(this.aliasMap.containsKey(key) ? this.aliasMap.get(key) : key);
        if (answer != null || ObjectHelper.isNotEmpty(key.getScheme())) {
            return answer;
        }
        TransformerKey alias = null;
        if (key.getFrom() != null && ObjectHelper.isNotEmpty(key.getFrom().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getModel()), key.getTo());
            answer = this.get(alias);
        }
        if (answer == null && ObjectHelper.isNotEmpty(key.getTo().getName())) {
            alias = new TransformerKey(key.getFrom(), new DataType(key.getTo().getModel()));
            answer = this.get(alias);
        }
        if (answer == null && key.getFrom() != null && ObjectHelper.isNotEmpty(key.getFrom().getName()) && ObjectHelper.isNotEmpty(key.getTo().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getModel()), new DataType(key.getTo().getModel()));
            answer = this.get(alias);
        }
        if (answer == null && key.getFrom() != null) {
            alias = new TransformerKey(key.getFrom().getModel());
            answer = this.get(alias);
        }
        if (answer == null) {
            alias = new TransformerKey(key.getTo().getModel());
            answer = this.get(alias);
        }
        if (answer != null) {
            this.aliasMap.put(key, alias);
        }
        return answer;
    }

    @Override
    public void start() throws Exception {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).resetStatistics();
        }
    }

    @Override
    public Transformer get(Object o) {
        Transformer answer = this.staticMap.get(o);
        if (answer == null) {
            answer = this.dynamicMap.get(o);
        }
        return answer;
    }

    @Override
    public Transformer put(TransformerKey key, Transformer transformer) {
        Transformer answer = this.staticMap.remove(key);
        if (answer != null) {
            this.staticMap.put(key, transformer);
            return answer;
        }
        answer = this.dynamicMap.remove(key);
        if (answer != null) {
            this.dynamicMap.put(key, transformer);
            return answer;
        }
        answer = this.context.isSetupRoutes() || this.context.isStartingRoutes() ? this.staticMap.put(key, transformer) : this.dynamicMap.put(key, transformer);
        return answer;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.staticMap.containsKey(o) || this.dynamicMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.staticMap.containsValue(o) || this.dynamicMap.containsValue(o);
    }

    @Override
    public int size() {
        return this.staticMap.size() + this.dynamicMap.size();
    }

    @Override
    public int staticSize() {
        return this.staticMap.size();
    }

    @Override
    public int dynamicSize() {
        return this.dynamicMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && this.dynamicMap.isEmpty();
    }

    @Override
    public Transformer remove(Object o) {
        Transformer answer = this.staticMap.remove(o);
        if (answer == null) {
            answer = this.dynamicMap.remove(o);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.staticMap.clear();
        this.dynamicMap.clear();
    }

    @Override
    public Set<Map.Entry<TransformerKey, Transformer>> entrySet() {
        return new AbstractSet<Map.Entry<TransformerKey, Transformer>>(){

            @Override
            public Iterator<Map.Entry<TransformerKey, Transformer>> iterator() {
                return new CompoundIterator<Map.Entry<TransformerKey, Transformer>>(Arrays.asList(DefaultTransformerRegistry.this.staticMap.entrySet().iterator(), DefaultTransformerRegistry.this.dynamicMap.entrySet().iterator()));
            }

            @Override
            public int size() {
                return DefaultTransformerRegistry.this.staticMap.size() + DefaultTransformerRegistry.this.dynamicMap.size();
            }
        };
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public void purge() {
        super.clear();
    }

    @Override
    public void cleanUp() {
        if (this.dynamicMap instanceof LRUCache) {
            ((LRUCache)this.dynamicMap).cleanUp();
        }
    }

    @Override
    public boolean isStatic(String scheme) {
        return this.staticMap.containsKey(new TransformerKey(scheme));
    }

    @Override
    public boolean isStatic(DataType from, DataType to) {
        return this.staticMap.containsKey(new TransformerKey(from, to));
    }

    @Override
    public boolean isDynamic(String scheme) {
        return this.dynamicMap.containsKey(new TransformerKey(scheme));
    }

    @Override
    public boolean isDynamic(DataType from, DataType to) {
        return this.dynamicMap.containsKey(new TransformerKey(from, to));
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.staticMap.values());
        ServiceHelper.stopServices(this.dynamicMap.values());
        this.purge();
    }

    @Override
    public String toString() {
        return "TransformerRegistry for " + this.context.getName() + ", capacity: " + this.maxCacheSize;
    }

    private TransformerKey createKey(TransformerDefinition def) {
        return ObjectHelper.isNotEmpty(def.getScheme()) ? new TransformerKey(def.getScheme()) : new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }
}

