/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;

public class Collection_MedianFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger(Collection_MedianFunction.class);
    FeatureCollection<? extends FeatureType, ? extends Feature> previousFeatureCollection = null;
    Object median = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Median", FunctionNameImpl.parameter("median", Comparable.class), FunctionNameImpl.parameter("expression", Comparable.class));

    public Collection_MedianFunction() {
        super(NAME);
    }

    static CalcResult calculateMedian(FeatureCollection<? extends FeatureType, ? extends Feature> collection, Expression expression) throws IllegalFilterException, IOException {
        MedianVisitor medianVisitor = new MedianVisitor(expression);
        collection.accepts(medianVisitor, null);
        return medianVisitor.getResult();
    }

    @Override
    public void setParameters(List<Expression> args) {
        Expression expr = args.get(0);
        expr = (Expression)expr.accept((ExpressionVisitor)new CollectionFeatureMemberFilterVisitor(), null);
        args.set(0, expr);
        super.setParameters(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        SimpleFeatureCollection featureCollection;
        if (feature == null) {
            return 0;
        }
        Expression expr = this.getExpression(0);
        SimpleFeatureCollection simpleFeatureCollection = featureCollection = (SimpleFeatureCollection)feature;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.median = null;
                try {
                    CalcResult result = Collection_MedianFunction.calculateMedian(featureCollection, expr);
                    if (result != null) {
                        this.median = result.getValue();
                    }
                }
                catch (IOException | IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.median;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

