/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.inspireatom.listener.setting;

import java.util.List;
import java.util.Optional;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.events.setting.SettingsChanged;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvesterScheduler;
import org.fao.geonet.utils.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class InspireAtomSettingsChangedListener
implements ApplicationListener<SettingsChanged> {
    public void onApplicationEvent(SettingsChanged event) {
        String oldSettingInspireScheduleValue = this.value(event.getOldSettings(), "system/inspire/atomSchedule");
        String newSettingInspireScheduleValue = this.value(event.getNewSettings(), "system/inspire/atomSchedule");
        String newSettingInspireEnabled = this.value(event.getNewSettings(), "system/inspire/enable");
        if (newSettingInspireEnabled.equalsIgnoreCase("true")) {
            String newSettingInspireTypeValue;
            String oldSettingInspireTypeValue = this.value(event.getOldSettings(), "system/inspire/atom");
            if (!oldSettingInspireTypeValue.equalsIgnoreCase(newSettingInspireTypeValue = this.value(event.getNewSettings(), "system/inspire/atom"))) {
                if (newSettingInspireTypeValue.equalsIgnoreCase("remote")) {
                    this.enableInspireAtomHarvester(newSettingInspireScheduleValue);
                } else {
                    this.disableInspireAtomHarvester();
                }
            } else if (newSettingInspireTypeValue.equalsIgnoreCase("remote") && !oldSettingInspireScheduleValue.equalsIgnoreCase(newSettingInspireScheduleValue)) {
                this.enableInspireAtomHarvester(newSettingInspireScheduleValue);
            }
        } else {
            this.disableInspireAtomHarvester();
        }
    }

    private void enableInspireAtomHarvester(String schedule) {
        try {
            GeonetContext gnContext = new GeonetContext((ApplicationContext)ApplicationContextHolder.get(), false);
            InspireAtomHarvesterScheduler.schedule(schedule, null, gnContext);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.atom", (String)("Error enabling INSPIRE Atom Harvester with schedule: " + schedule), (Throwable)e);
        }
    }

    private void disableInspireAtomHarvester() {
        try {
            InspireAtomHarvesterScheduler.unSchedule();
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.atom", (String)"Error disabling INSPIRE Atom Harvester: ", (Throwable)e);
        }
    }

    private String value(List<Setting> settings, String settingName) {
        Optional<Setting> settingOptional = settings.stream().filter(setting -> setting.getName().equalsIgnoreCase(settingName)).findFirst();
        if (settingOptional.isPresent()) {
            return settingOptional.get().getValue();
        }
        return "";
    }
}

