/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.camelPeriodicProducer;

import io.swagger.v3.oas.annotations.Operation;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import org.fao.geonet.camelPeriodicProducer.MessageProducerFactory;
import org.fao.geonet.camelPeriodicProducer.MessageProducerService;
import org.fao.geonet.domain.MessageProducerEntity;
import org.fao.geonet.repository.MessageProducerRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{portal}/api/msg_producers"})
public class MessageProducerController {
    @Autowired
    protected MessageProducerFactory messageProducerFactory;
    @PersistenceContext
    protected EntityManager entityManager;
    @Autowired
    protected MessageProducerService messageProducerService;
    protected MessageProducerRepository msgProducerRepository;

    public MessageProducerController(MessageProducerRepository msgProducerRepository) {
        this.msgProducerRepository = msgProducerRepository;
    }

    @PreAuthorize(value="hasAuthority('Administrator')")
    @GetMapping
    public List findAll() {
        return this.msgProducerRepository.findAll();
    }

    @PreAuthorize(value="hasAuthority('Administrator')")
    @GetMapping(path={"/{id}"})
    public ResponseEntity<MessageProducerEntity> findById(@PathVariable long id) {
        Optional message = this.msgProducerRepository.findById((Object)id);
        if (message.isPresent()) {
            return ResponseEntity.ok().body((Object)((MessageProducerEntity)message.get()));
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PreAuthorize(value="hasAuthority('Administrator')")
    @GetMapping(path={"/find"})
    public ResponseEntity<MessageProducerEntity> findByUrlAndFeatureType(@RequestParam String url, @RequestParam String featureType) {
        MessageProducerEntity msg = this.msgProducerRepository.findOneByUrlAndFeatureType(url, featureType);
        if (msg != null) {
            return ResponseEntity.ok().body((Object)msg);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Create and save a message to trigger data indexing.", description="If existing (same URL, same feature type), update and start the process.")
    @PreAuthorize(value="hasAuthority('Administrator')")
    @PostMapping
    public ResponseEntity<?> create(@RequestBody MessageProducerEntity messageProducerEntity) {
        MessageProducerEntity message = this.msgProducerRepository.findOneByUrlAndFeatureType(messageProducerEntity.getWfsHarvesterParam().getUrl(), messageProducerEntity.getWfsHarvesterParam().getTypeName());
        if (message != null) {
            this.update(message.getId(), messageProducerEntity, true);
            return ResponseEntity.ok().body((Object)messageProducerEntity);
        }
        try (InnerEntityManager innerEntityManager = new InnerEntityManager();){
            messageProducerEntity = innerEntityManager.beginMergeAndPersist(messageProducerEntity);
            this.messageProducerService.registerAndStart(messageProducerEntity);
            innerEntityManager.commit();
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)messageProducerEntity);
            return responseEntity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasAuthority('Administrator')")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<?> update(@PathVariable(value="id") long id, @RequestBody MessageProducerEntity messageProducerEntity, boolean registerAndStart) {
        if (this.msgProducerRepository.existsById((Object)id)) {
            try (InnerEntityManager innerEntityManager = new InnerEntityManager();){
                messageProducerEntity.setId(Long.valueOf(id));
                messageProducerEntity = innerEntityManager.beginMergeAndPersist(messageProducerEntity);
                if (registerAndStart) {
                    this.messageProducerService.registerAndStart(messageProducerEntity);
                } else {
                    this.messageProducerService.changeMessageAndReschedule(messageProducerEntity);
                }
                innerEntityManager.commit();
                ResponseEntity responseEntity = ResponseEntity.ok().body((Object)messageProducerEntity);
                return responseEntity;
            }
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PreAuthorize(value="hasAuthority('Administrator')")
    @DeleteMapping(path={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable(value="id") long id) throws Exception {
        if (this.msgProducerRepository.existsById((Object)id)) {
            this.msgProducerRepository.deleteById((Object)id);
            this.messageProducerService.destroy(id);
            return ResponseEntity.ok().build();
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    private String sqlCause(PersistenceException e) {
        Throwable cause = e;
        for (int level = 0; level < 5 && cause.getCause() != null && !(cause instanceof SQLException); ++level) {
            cause = cause.getCause();
        }
        if (cause instanceof SQLException) {
            return cause.getMessage();
        }
        return e.getMessage();
    }

    private class InnerEntityManager
    implements Closeable {
        private EntityManager innerEntityMananger;

        public InnerEntityManager() {
            this.innerEntityMananger = MessageProducerController.this.entityManager.getEntityManagerFactory().createEntityManager();
        }

        public MessageProducerEntity beginMergeAndPersist(MessageProducerEntity messageProducerEntity) {
            this.innerEntityMananger.getTransaction().begin();
            messageProducerEntity = (MessageProducerEntity)this.innerEntityMananger.merge((Object)messageProducerEntity);
            this.innerEntityMananger.persist((Object)messageProducerEntity);
            return messageProducerEntity;
        }

        public void rollback() {
            if (this.innerEntityMananger.getTransaction().isActive()) {
                this.innerEntityMananger.getTransaction().rollback();
            }
        }

        public void commit() {
            this.innerEntityMananger.getTransaction().commit();
        }

        @Override
        public void close() {
            this.innerEntityMananger.close();
        }
    }

    class ErrorResponse {
        private String error;
        private String message;

        ErrorResponse(String error, String message) {
            this.error = error;
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

