/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.logging.Level;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;

public class MeteosatSG
extends MapProjection {
    private static final long serialVersionUID = -6360986801876534108L;
    private static final double SAT_HEIGHT = 42164.0;
    private static final double R_EQ = 6378.169;
    private static final double R_POL = 6356.5838;
    private static final double SUB_LON = 0.0;
    private static final double CFAC_NONHRV = -7.81648343E8;
    private static final double LFAC_NONHRV = -7.81648343E8;
    private static final long COFF_NONHRV = 1856L;
    private static final long LOFF_NONHRV = 1856L;
    private static final double SCALE_FACTOR = 6378137.0;

    protected MeteosatSG(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double re;
        double r1 = 0.0;
        double r2 = 0.0;
        double r3 = 0.0;
        double lfac = -7.81648343E8;
        double cfac = -7.81648343E8;
        long coff = 1856L;
        long loff = 1856L;
        double c_lat = Math.atan(0.993243 * (Math.sin(y) / Math.cos(y)));
        double cos_c_lat = Math.cos(c_lat);
        double cos_x_SUB_LON = Math.cos(x - 0.0);
        double rl = re = 6356.5838 / Math.sqrt(1.0 - 0.00675701 * cos_c_lat * cos_c_lat);
        r1 = 42164.0 - rl * cos_c_lat * cos_x_SUB_LON;
        r2 = -rl * cos_c_lat * Math.sin(x - 0.0);
        r3 = rl * Math.sin(c_lat);
        double rn = Math.sqrt(r1 * r1 + r2 * r2 + r3 * r3);
        double dotprod = r1 * (rl * cos_c_lat * cos_x_SUB_LON) - r2 * r2 - r3 * r3 * Math.pow(1.0033957233443536, 2.0);
        if (dotprod <= 0.0) {
            double col_norm = 9.093564468746908E-6;
            double row_norm = 2.9099406299990107E-4;
            if (ptDst != null) {
                ptDst.setLocation(col_norm, row_norm);
                LOGGER.log(Level.INFO, "MeteosatSG transform: Lon/lat outside vaild range, lon=" + x + " lat=" + y + " Col/row set arbitrary to 58,1856 (0N, 74.48E");
                return ptDst;
            }
            return new Point2D.Double(col_norm, row_norm);
        }
        double xx = Math.atan(-r2 / r1);
        double yy = Math.asin(-r3 / rn);
        double cc = (double)coff + xx * Math.pow(2.0, -16.0) * cfac;
        double ll = (double)loff + yy * Math.pow(2.0, -16.0) * lfac;
        double col_norm = cc / 6378137.0;
        double row_norm = ll / 6378137.0;
        if (ptDst != null) {
            ptDst.setLocation(col_norm, row_norm);
            LOGGER.log(Level.FINE, "MeteosatSG transform: col=" + cc + " row=" + ll);
            return ptDst;
        }
        return new Point2D.Double(col_norm, row_norm);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double cos_y1;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double sn = 0.0;
        double lfac = -7.81648343E8;
        double cfac = -7.81648343E8;
        long coff = 1856L;
        long loff = 1856L;
        double x1 = 65536.0 * ((x *= 6378137.0) - (double)coff) / cfac;
        double y1 = 65536.0 * ((y *= 6378137.0) - (double)loff) / lfac;
        double sin_y1 = Math.sin(y1);
        double cos_x1 = Math.cos(x1);
        double sa = Math.pow(42164.0 * cos_x1 * (cos_y1 = Math.cos(y1)), 2.0) - (cos_y1 * cos_y1 + 1.006803 * sin_y1 * sin_y1) * 1.737121856E9;
        if (sa <= 0.0) {
            double lat = 0.0;
            double lon = 1.2998982273;
            if (ptDst != null) {
                ptDst.setLocation(lat, lon);
                LOGGER.log(Level.INFO, "MeteosatSG inverse transform: Column/row outside vaild range, x=" + x + " y=" + y + " Lat/lon set to (0N, 74.48E)");
                return ptDst;
            }
            return new Point2D.Double(lon, lat);
        }
        double sd = Math.sqrt(Math.pow(42164.0 * cos_x1 * cos_y1, 2.0) - (cos_y1 * cos_y1 + 1.006803 * sin_y1 * sin_y1) * 1.737121856E9);
        sn = (42164.0 * cos_x1 * cos_y1 - sd) / (cos_y1 * cos_y1 + 1.006803 * sin_y1 * sin_y1);
        s1 = 42164.0 - sn * cos_x1 * cos_y1;
        s2 = sn * Math.sin(x1) * cos_y1;
        s3 = -sn * sin_y1;
        double sxy = Math.sqrt(s1 * s1 + s2 * s2);
        double lon = Math.atan(s2 / s1) + 0.0;
        double lat = Math.atan(1.006803 * s3 / sxy);
        if (ptDst != null) {
            ptDst.setLocation(lon, lat);
            LOGGER.log(Level.FINE, "MeteosatSG inverse transform: col=" + x + " row=" + y);
            return ptDst;
        }
        return new Point2D.Double(lon, lat);
    }

    @Override
    protected double getToleranceForAssertions(double longitude, double latitude) {
        double delta = Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfOrigin);
        if (delta > 40.0) {
            return 3.0;
        }
        return Math.abs(longitude) > 179.0 || Math.abs(latitude) > 89.0 ? 0.5 : 0.3;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -2722451724278085168L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.AUTO, "MeteosatSG")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            if (Provider.isSpherical(parameters)) {
                MapProjection.LOGGER.log(Level.INFO, "MeteosatSG conversion assumes ellipsoidal Earth shape. Be aware of possibe errors arising from mixing ellipsoidal equations with spherical coordinates.");
                return new MeteosatSG(parameters);
            }
            return new MeteosatSG(parameters);
        }
    }
}

