/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.DelegatingHandler;
import org.geotools.geojson.feature.AttributeIO;
import org.geotools.geojson.feature.CRSHandler;
import org.geotools.geojson.feature.DefaultAttributeIO;
import org.geotools.geojson.feature.FeatureHandler;
import org.geotools.geojson.feature.FeatureTypeAttributeIO;
import org.geotools.geojson.feature.IFeatureCollectionHandler;
import org.json.simple.parser.ParseException;

public class FeatureCollectionHandler
extends DelegatingHandler<SimpleFeature>
implements IFeatureCollectionHandler {
    SimpleFeatureBuilder builder;
    AttributeIO attio;
    SimpleFeature feature;
    CoordinateReferenceSystem crs;
    protected List<Integer> stack;

    public FeatureCollectionHandler() {
        this(null, null);
    }

    public FeatureCollectionHandler(SimpleFeatureType featureType, AttributeIO attio) {
        if (featureType != null) {
            this.builder = new SimpleFeatureBuilder(featureType);
        }
        if (attio == null) {
            attio = featureType != null ? new FeatureTypeAttributeIO(featureType) : new DefaultAttributeIO();
        }
        this.attio = attio;
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("features".equals(key)) {
            this.delegate = UNINITIALIZED;
            return true;
        }
        if ("crs".equals(key)) {
            this.delegate = new CRSHandler();
            return true;
        }
        return super.startObjectEntry(key);
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        if (this.delegate == UNINITIALIZED) {
            this.delegate = new FeatureHandler(this.builder, this.attio);
            if (this.crs != null) {
                ((FeatureHandler)this.delegate).setCRS(this.crs);
            }
            this.stack = new ArrayList<Integer>();
            return true;
        }
        if (this.stack != null) {
            this.stack.add(null);
        }
        return super.startArray();
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        if (this.stack != null) {
            if (this.stack.isEmpty()) {
                this.delegate = NULL;
                return true;
            }
            this.stack.remove(0);
        }
        return super.endArray();
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        super.endObject();
        if (this.delegate instanceof FeatureHandler) {
            this.feature = ((FeatureHandler)this.delegate).getValue();
            if (this.feature != null) {
                if (this.builder == null) {
                    SimpleFeatureType featureType = this.feature.getFeatureType();
                    if (featureType.getCoordinateReferenceSystem() == null && this.crs != null) {
                        featureType = SimpleFeatureTypeBuilder.retype(featureType, this.crs);
                    }
                    this.builder = new SimpleFeatureBuilder(featureType);
                }
                ((FeatureHandler)this.delegate).init();
                return false;
            }
        } else if (this.delegate instanceof CRSHandler) {
            this.crs = ((CRSHandler)this.delegate).getValue();
            if (this.crs != null) {
                this.delegate = NULL;
            }
        }
        return true;
    }

    @Override
    public void endJSON() throws ParseException, IOException {
        this.delegate = null;
        this.feature = null;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    @Override
    public SimpleFeature getValue() {
        return this.feature;
    }
}

