/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.tilecache;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jaitools.tilecache.DiskCachedTile;
import org.jaitools.tilecache.DiskMemTileCacheVisitor;

public class BasicCacheVisitor
implements DiskMemTileCacheVisitor {
    private List<DiskCachedTile> tiles = new ArrayList<DiskCachedTile>();
    private Map<Key, Object> filters = new LinkedHashMap<Key, Object>();

    public void setFilters(Map<Key, Object> params) {
        this.filters.clear();
        for (Map.Entry<Key, Object> e : params.entrySet()) {
            this.addFilter(e.getKey(), e.getValue());
        }
    }

    public void setFilter(Key key, Object value) {
        this.filters.clear();
        this.addFilter(key, value);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public Collection<DiskCachedTile> getTiles() {
        return Collections.unmodifiableCollection(this.tiles);
    }

    @Override
    public void visit(DiskCachedTile tile, boolean isResident) {
        if (this.filters.isEmpty()) {
            this.tiles.add(tile);
        } else {
            boolean pass = true;
            if (this.filters.containsKey((Object)Key.OWNER) && !tile.getOwner().equals(this.filters.get((Object)Key.OWNER))) {
                pass = false;
            }
            if (pass && this.filters.containsKey((Object)Key.RESIDENT) && (Boolean)this.filters.get((Object)Key.RESIDENT) != isResident) {
                pass = false;
            }
            if (pass) {
                this.tiles.add(tile);
            }
        }
    }

    public void clear() {
        this.tiles.clear();
    }

    private void addFilter(Key key, Object value) {
        if (!key.getValueClass().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(String.format("Object of type %s cannot be used as value for %s", value.getClass().getName(), key.toString()));
        }
        this.filters.put(key, value);
    }

    public static enum Key {
        OWNER(RenderedImage.class),
        RESIDENT(Boolean.class);

        private Class<?> clazz;

        private Key(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getValueClass() {
            return this.clazz;
        }
    }
}

