/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.BooleanExprEvaluationException;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.ValueCompare;
import org.openrdf.sesame.sail.query.ValueExpr;

public class CompareAll
implements BooleanExpr {
    private ValueExpr _valueExpr;
    private Query _qc;
    private int _operator;

    public CompareAll(ValueExpr valueExpr, Query qc, int op) {
        this._valueExpr = valueExpr;
        this._qc = qc;
        this._operator = op;
    }

    public ValueExpr getLeftArg() {
        return this._valueExpr;
    }

    public Query getRightArg() {
        return this._qc;
    }

    public int getOperator() {
        return this._operator;
    }

    public void getVariables(Collection variables) {
        this._valueExpr.getVariables(variables);
        this._qc.getVariables(variables);
    }

    public boolean isTrue(RdfSource rdfSource) throws SailQueryException {
        ValueListCompare vlc = new ValueListCompare();
        this._qc.evaluate(rdfSource, vlc);
        return vlc.isTrue();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this._valueExpr.toString());
        buf.append(' ');
        buf.append(ValueCompare.operator2string(this._operator));
        buf.append(" ALL ");
        buf.append(this._qc.toString());
        return buf.toString();
    }

    private class ValueListCompare
    implements QueryAnswerListener {
        private boolean _isTrue = true;

        private ValueListCompare() {
        }

        public boolean queryAnswer(QueryAnswer qa) {
            try {
                this._isTrue = ValueCompare.isTrue(CompareAll.this._valueExpr.getValue(), qa.getValue(0), CompareAll.this._operator);
            }
            catch (BooleanExprEvaluationException e) {
                this._isTrue = false;
            }
            return this._isTrue;
        }

        public void clear() {
            this._isTrue = true;
        }

        public boolean isTrue() {
            return this._isTrue;
        }
    }
}

