/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
define(["./defined-2a4f2d00","./Check-e5651467","./freezeObject-a51e076f","./defaultValue-29c9b1af","./Math-7782f09e","./Cartesian2-ba70b51f","./defineProperties-c817531e","./Transforms-5119c07b","./RuntimeError-51c34ab4","./WebGLConstants-90dbfe2f","./ComponentDatatype-418b1c61","./GeometryAttribute-8bc1900e","./when-1faa3867","./GeometryAttributes-f8548d3f","./IndexDatatype-2bcfc06b","./createTaskProcessorWorker","./GeometryOffsetAttribute-fa4e7a11","./VertexFormat-e2e35139","./BoxGeometry-303fc346","./CylinderGeometryLibrary-f35c6b75","./CylinderGeometry-b2227fa7","./EllipsoidGeometry-d739b425","./Color-e0436000"],function(F,e,t,n,r,R,a,P,i,o,s,d,f,c,Z,l,u,h,D,b,q,W,S){"use strict";function V(e){this.offset=e.offset,this.count=e.count,this.color=e.color,this.batchIds=e.batchIds}var p=new R.Cartesian3,y=P.Matrix4.packedLength+R.Cartesian3.packedLength,x=P.Matrix4.packedLength+2,g=P.Matrix4.packedLength+R.Cartesian3.packedLength,v=R.Cartesian3.packedLength+1,C={modelMatrix:new P.Matrix4,boundingVolume:new P.BoundingSphere};function _(e,t){var n=t*y,r=R.Cartesian3.unpack(e,n,p);n+=R.Cartesian3.packedLength;var a=P.Matrix4.unpack(e,n,C.modelMatrix);P.Matrix4.multiplyByScale(a,r,a);var i=C.boundingVolume;return R.Cartesian3.clone(R.Cartesian3.ZERO,i.center),i.radius=Math.sqrt(3),C}function j(e,t){var n=t*x,r=e[n++],a=e[n++],i=R.Cartesian3.fromElements(r,r,a,p),o=P.Matrix4.unpack(e,n,C.modelMatrix);P.Matrix4.multiplyByScale(o,i,o);var s=C.boundingVolume;return R.Cartesian3.clone(R.Cartesian3.ZERO,s.center),s.radius=Math.sqrt(2),C}function z(e,t){var n=t*g,r=R.Cartesian3.unpack(e,n,p);n+=R.Cartesian3.packedLength;var a=P.Matrix4.unpack(e,n,C.modelMatrix);P.Matrix4.multiplyByScale(a,r,a);var i=C.boundingVolume;return R.Cartesian3.clone(R.Cartesian3.ZERO,i.center),i.radius=1,C}function N(e,t){var n=t*v,r=e[n++],a=R.Cartesian3.unpack(e,n,p),i=P.Matrix4.fromTranslation(a,C.modelMatrix);P.Matrix4.multiplyByUniformScale(i,r,i);var o=C.boundingVolume;return R.Cartesian3.clone(R.Cartesian3.ZERO,o.center),o.radius=1,C}var T=new R.Cartesian3;function Y(e,t,n,r,a){if(F.defined(t)){for(var i=n.length,o=r.attributes.position.values,s=r.indices,d=e.positions,f=e.vertexBatchIds,c=e.indices,l=e.batchIds,u=e.batchTableColors,h=e.batchedIndices,b=e.indexOffsets,p=e.indexCounts,y=e.boundingVolumes,x=e.modelMatrix,g=e.center,v=e.positionOffset,C=e.batchIdIndex,m=e.indexOffset,I=e.batchedIndicesOffset,k=0;k<i;++k){var M=a(t,k),B=M.modelMatrix;P.Matrix4.multiply(x,B,B);for(var w=n[k],A=o.length,O=0;O<A;O+=3){var L=R.Cartesian3.unpack(o,O,T);P.Matrix4.multiplyByPoint(B,L,L),R.Cartesian3.subtract(L,g,L),R.Cartesian3.pack(L,d,3*v+O),f[C++]=w}for(var E=s.length,U=0;U<E;++U)c[m+U]=s[U]+v;var G=k+I;h[G]=new V({offset:m,count:E,color:S.Color.fromRgba(u[w]),batchIds:[w]}),l[G]=w,b[G]=m,p[G]=E,y[G]=P.BoundingSphere.transform(M.boundingVolume,B),v+=A/3,m+=E}e.positionOffset=v,e.batchIdIndex=C,e.indexOffset=m,e.batchedIndicesOffset+=i}}var H=new R.Cartesian3,J=new P.Matrix4;function K(e,t,n){var r=n.length,a=2+r*P.BoundingSphere.packedLength+1+function(e){for(var t=e.length,n=0,r=0;r<t;++r)n+=S.Color.packedLength+3+e[r].batchIds.length;return n}(t),i=new Float64Array(a),o=0;i[o++]=e,i[o++]=r;for(var s=0;s<r;++s)P.BoundingSphere.pack(n[s],i,o),o+=P.BoundingSphere.packedLength;var d=t.length;i[o++]=d;for(var f=0;f<d;++f){var c=t[f];S.Color.pack(c.color,i,o),o+=S.Color.packedLength,i[o++]=c.offset,i[o++]=c.count;var l=c.batchIds,u=l.length;i[o++]=u;for(var h=0;h<u;++h)i[o++]=l[h]}return i}return l(function(e,t){var n=F.defined(e.boxes)?new Float32Array(e.boxes):void 0,r=F.defined(e.boxBatchIds)?new Uint16Array(e.boxBatchIds):void 0,a=F.defined(e.cylinders)?new Float32Array(e.cylinders):void 0,i=F.defined(e.cylinderBatchIds)?new Uint16Array(e.cylinderBatchIds):void 0,o=F.defined(e.ellipsoids)?new Float32Array(e.ellipsoids):void 0,s=F.defined(e.ellipsoidBatchIds)?new Uint16Array(e.ellipsoidBatchIds):void 0,d=F.defined(e.spheres)?new Float32Array(e.spheres):void 0,f=F.defined(e.sphereBatchIds)?new Uint16Array(e.sphereBatchIds):void 0,c=F.defined(n)?r.length:0,l=F.defined(a)?i.length:0,u=F.defined(o)?s.length:0,h=F.defined(d)?f.length:0,b=D.BoxGeometry.getUnitBox(),p=q.CylinderGeometry.getUnitCylinder(),y=W.EllipsoidGeometry.getUnitEllipsoid(),x=b.attributes.position.values,g=p.attributes.position.values,v=y.attributes.position.values,C=x.length*c;C+=g.length*l,C+=v.length*(u+h);var m=b.indices,I=p.indices,k=y.indices,M=m.length*c;M+=I.length*l,M+=k.length*(u+h);var B=new Float32Array(C),w=new Uint16Array(C/3),A=Z.IndexDatatype.createTypedArray(C/3,M),O=c+l+u+h,L=new Uint16Array(O),E=new Array(O),U=new Uint32Array(O),G=new Uint32Array(O),S=new Array(O);!function(e){var t=new Float64Array(e),n=0;R.Cartesian3.unpack(t,n,H),n+=R.Cartesian3.packedLength,P.Matrix4.unpack(t,n,J)}(e.packedBuffer);var V={batchTableColors:new Uint32Array(e.batchTableColors),positions:B,vertexBatchIds:w,indices:A,batchIds:L,batchedIndices:E,indexOffsets:U,indexCounts:G,boundingVolumes:S,positionOffset:0,batchIdIndex:0,indexOffset:0,batchedIndicesOffset:0,modelMatrix:J,center:H};Y(V,n,r,b,_),Y(V,a,i,p,j),Y(V,o,s,y,z),Y(V,d,f,y,N);var T=K(A.BYTES_PER_ELEMENT,E,S);return t.push(B.buffer,w.buffer,A.buffer),t.push(L.buffer,U.buffer,G.buffer),t.push(T.buffer),{positions:B.buffer,vertexBatchIds:w.buffer,indices:A.buffer,indexOffsets:U.buffer,indexCounts:G.buffer,batchIds:L.buffer,packedBuffer:T.buffer}})});
