/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jaitools.numeric.AbstractProcessor;
import org.jaitools.numeric.Statistic;

public class ExtremaProcessor
extends AbstractProcessor {
    private static final Set<Statistic> SUPPORTED = new HashSet<Statistic>();
    private double min;
    private double max;

    @Override
    public Collection<Statistic> getSupported() {
        return Collections.unmodifiableCollection(SUPPORTED);
    }

    @Override
    protected boolean update(Double sample) {
        if (this.isAccepted(sample)) {
            if (this.getNumAccepted() == 0L) {
                this.min = this.max = sample.doubleValue();
            } else {
                if (sample > this.max) {
                    this.max = sample;
                }
                if (sample < this.min) {
                    this.min = sample;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Double get(Statistic stat) {
        if (this.getNumAccepted() == 0L) {
            return Double.NaN;
        }
        switch (stat) {
            case MAX: {
                return this.max;
            }
            case MIN: {
                return this.min;
            }
            case RANGE: {
                return this.max - this.min;
            }
        }
        throw new IllegalArgumentException((Object)((Object)stat) + " not supported by " + this.getClass().getName());
    }

    static {
        SUPPORTED.add(Statistic.MAX);
        SUPPORTED.add(Statistic.MIN);
        SUPPORTED.add(Statistic.RANGE);
    }
}

