/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wmts.bindings;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.DatasetDescriptionSummaryBaseType;
import net.opengis.ows11.MetadataType;
import net.opengis.wmts.v_1.DimensionType;
import net.opengis.wmts.v_1.LayerType;
import net.opengis.wmts.v_1.StyleType;
import net.opengis.wmts.v_1.TileMatrixSetLinkType;
import net.opengis.wmts.v_1.URLTemplateType;
import net.opengis.wmts.v_1.wmtsv_1Factory;
import org.geotools.wmts.WMTS;
import org.geotools.xsd.AbstractSimpleBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

public class LayerBinding
extends AbstractSimpleBinding {
    wmtsv_1Factory factory;

    public LayerBinding(wmtsv_1Factory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return WMTS.Layer;
    }

    public Class<LayerType> getType() {
        return LayerType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LayerType layer = this.factory.createLayerType();
        List children = node.getChildren("Abstract");
        for (Node c : children) {
            layer.getAbstract().add(c.getValue());
        }
        children = node.getChildren("BoundingBox");
        for (Node c : children) {
            layer.getBoundingBox().add(c.getValue());
        }
        layer.getWGS84BoundingBox().add(node.getChildValue("WGS84BoundingBox"));
        layer.getDatasetDescriptionSummary().addAll((Collection)node.getChildren(DatasetDescriptionSummaryBaseType.class));
        layer.getDimension().addAll((Collection)node.getChildValues(DimensionType.class));
        children = node.getChildren("Format");
        for (Node c : children) {
            layer.getFormat().add((Object)((String)c.getValue()));
        }
        children = node.getChildren("InfoFormat");
        for (Node c : children) {
            layer.getInfoFormat().add((Object)((String)c.getValue()));
        }
        layer.setIdentifier((CodeType)node.getChildValue("Identifier"));
        layer.getKeywords().addAll((Collection)node.getChildren("Keyword"));
        layer.getMetadata().addAll((Collection)node.getChildren(MetadataType.class));
        layer.getResourceURL().addAll((Collection)node.getChildValues(URLTemplateType.class));
        children = node.getChildren("Style");
        for (Node c : children) {
            layer.getStyle().add((Object)((StyleType)c.getValue()));
        }
        List children2 = node.getChildren(TileMatrixSetLinkType.class);
        for (Node c : children2) {
            layer.getTileMatrixSetLink().add((Object)((TileMatrixSetLinkType)c));
        }
        children = node.getChildren("Title");
        for (Node c : children) {
            layer.getTitle().add(c.getValue());
        }
        return layer;
    }
}

