/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.persistence.PersistenceException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractToOneMapper;
import org.hibernate.envers.internal.entities.mapper.relation.ToOneEntityLoader;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.logging.Logger;

public class ToOneIdMapper
extends AbstractToOneMapper {
    private static final Logger log = Logger.getLogger(ToOneIdMapper.class);
    private final IdMapper delegate;
    private final String referencedEntityName;
    private final boolean nonInsertableFake;
    private final boolean lazyMapping;

    public ToOneIdMapper(IdMapper delegate, PropertyData propertyData, String referencedEntityName, boolean nonInsertableFake, boolean lazyMapping) {
        super(delegate.getServiceRegistry(), propertyData);
        this.delegate = delegate;
        this.referencedEntityName = referencedEntityName;
        this.nonInsertableFake = nonInsertableFake;
        this.lazyMapping = lazyMapping;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        Object entity;
        HashMap<String, Object> newData = new HashMap<String, Object>();
        Object object = entity = this.nonInsertableFake ? oldObj : newObj;
        if (this.lazyMapping && entity instanceof HibernateProxy) {
            try {
                entity = ((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
            }
            catch (PersistenceException e) {
                log.debug((Object)"Ignore PersistenceException while initializing the entity, and fallback to call mapToMapFromEntity directly");
            }
        }
        this.delegate.mapToMapFromEntity(newData, entity);
        for (Map.Entry<String, Object> entry : newData.entrySet()) {
            data.put(entry.getKey(), entry.getValue());
        }
        return this.checkModified(session, newObj, oldObj);
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        if (this.getPropertyData().isUsingModifiedFlag()) {
            data.put(this.getPropertyData().getModifiedFlagPropertyName(), this.checkModified(session, newObj, oldObj));
        }
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        if (this.getPropertyData().isUsingModifiedFlag()) {
            data.put(this.getPropertyData().getModifiedFlagPropertyName(), collectionPropertyName.equals(this.getPropertyData().getName()));
        }
    }

    protected boolean checkModified(SessionImplementor session, Object newObj, Object oldObj) {
        if (this.nonInsertableFake) {
            return false;
        }
        if (newObj == null || oldObj == null || newObj.getClass().equals(oldObj.getClass())) {
            return !EntityTools.entitiesEqual(session, this.referencedEntityName, newObj, oldObj);
        }
        EntityPersister persister = session.getFactory().getMetamodel().entityPersister(this.referencedEntityName);
        Object resolvedNewObjectId = newObj;
        if (!persister.getIdentifierType().getReturnedClass().isInstance(newObj)) {
            resolvedNewObjectId = EntityTools.getIdentifier(session, this.referencedEntityName, newObj);
        }
        Object resolvedOldObjectId = oldObj;
        if (!persister.getIdentifierType().getReturnedClass().isInstance(oldObj)) {
            resolvedOldObjectId = EntityTools.getIdentifier(session, this.referencedEntityName, oldObj);
        }
        return !Objects.deepEquals(resolvedNewObjectId, resolvedOldObjectId);
    }

    @Override
    public void nullSafeMapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object entityId = this.delegate.mapToIdFromMap(data);
        Object value = null;
        if (entityId != null) {
            if (versionsReader.getFirstLevelCache().contains(this.referencedEntityName, revision, entityId)) {
                value = versionsReader.getFirstLevelCache().get(this.referencedEntityName, revision, entityId);
            } else {
                AbstractToOneMapper.EntityInfo referencedEntity = this.getEntityInfo(enversService, this.referencedEntityName);
                boolean ignoreNotFound = false;
                if (!referencedEntity.isAudited()) {
                    String referencingEntityName = enversService.getEntitiesConfigurations().getEntityNameForVersionsEntityName((String)data.get("$type$"));
                    ignoreNotFound = referencingEntityName == null && primaryKey == null ? true : enversService.getEntitiesConfigurations().getRelationDescription(referencingEntityName, this.getPropertyData().getName()).isIgnoreNotFound();
                }
                value = ignoreNotFound ? ToOneEntityLoader.loadImmediate(versionsReader, referencedEntity.getEntityClass(), this.referencedEntityName, entityId, revision, RevisionType.DEL.equals(data.get(enversService.getAuditEntitiesConfiguration().getRevisionTypePropName())), enversService) : ToOneEntityLoader.createProxyOrLoadImmediate(versionsReader, referencedEntity.getEntityClass(), this.referencedEntityName, entityId, revision, RevisionType.DEL.equals(data.get(enversService.getAuditEntitiesConfiguration().getRevisionTypePropName())), enversService);
            }
        }
        this.setPropertyValue(obj, value);
    }

    public void addMiddleEqualToQuery(Parameters parameters, String idPrefix1, String prefix1, String idPrefix2, String prefix2) {
        this.delegate.addIdsEqualToQuery(parameters, prefix1, this.delegate, prefix2);
    }
}

