/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BBOX3D;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.api.geometry.BoundingBox3D;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.postgis.PostgisFilterToSQL;
import org.geotools.data.postgis.PostgisPSFilterToSql;
import org.geotools.data.postgis.filter.FilterFunction_pgNearest;
import org.geotools.data.util.DistanceBufferUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.LengthFunction;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.function.DateDifferenceFunction;
import org.geotools.filter.function.FilterFunction_area;
import org.geotools.filter.function.FilterFunction_buffer;
import org.geotools.filter.function.FilterFunction_equalTo;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strReplace;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.FilterFunction_strTrim2;
import org.geotools.filter.function.InArrayFunction;
import org.geotools.filter.function.JsonArrayContainsFunction;
import org.geotools.filter.function.JsonPointerFunction;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.JTS;
import org.geotools.jdbc.EscapeSql;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.Version;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

class FilterToSqlHelper {
    protected static final String IO_ERROR = "io problem writing filter";
    private static final Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    private static final Boolean DISABLE_CURVE_ACCURATE_INTERSECTION = Boolean.getBoolean("org.geotools.postgis.disableCurveAccurateIntersection");
    FilterToSQL delegate;
    Writer out;
    boolean looseBBOXEnabled;
    boolean encodeBBOXFilterAsEnvelope;
    boolean jsonPathExistsSupported;

    public FilterToSqlHelper(FilterToSQL delegate) {
        this.delegate = delegate;
        this.jsonPathExistsSupported = false;
    }

    public FilterToSqlHelper(FilterToSQL delegate, Version pgVersion) {
        this.delegate = delegate;
        this.jsonPathExistsSupported = this.postgresMajorVersionIsEqualOrGreaterThan(pgVersion, PostGISDialect.PGSQL_V_12_0);
    }

    public static FilterCapabilities createFilterCapabilities(boolean encodeFunctions) {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(BBOX3D.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addType(After.class);
        caps.addType(Before.class);
        caps.addType(Begins.class);
        caps.addType(BegunBy.class);
        caps.addType(During.class);
        caps.addType(TOverlaps.class);
        caps.addType(Ends.class);
        caps.addType(EndedBy.class);
        caps.addType(TEquals.class);
        caps.addType(JsonArrayContainsFunction.class);
        caps.addType(FilterFunction_area.class);
        if (encodeFunctions) {
            caps.addType(FilterFunction_strConcat.class);
            caps.addType(FilterFunction_strEndsWith.class);
            caps.addType(FilterFunction_strStartsWith.class);
            caps.addType(FilterFunction_strEqualsIgnoreCase.class);
            caps.addType(FilterFunction_strIndexOf.class);
            caps.addType(FilterFunction_strLength.class);
            caps.addType(LengthFunction.class);
            caps.addType(FilterFunction_strToLowerCase.class);
            caps.addType(FilterFunction_strToUpperCase.class);
            caps.addType(FilterFunction_strReplace.class);
            caps.addType(FilterFunction_strSubstring.class);
            caps.addType(FilterFunction_strSubstringStart.class);
            caps.addType(FilterFunction_strTrim.class);
            caps.addType(FilterFunction_strTrim2.class);
            caps.addType(FilterFunction_abs.class);
            caps.addType(FilterFunction_abs_2.class);
            caps.addType(FilterFunction_abs_3.class);
            caps.addType(FilterFunction_abs_4.class);
            caps.addType(FilterFunction_ceil.class);
            caps.addType(FilterFunction_floor.class);
            caps.addType(DateDifferenceFunction.class);
            caps.addType(FilterFunction_pgNearest.class);
            caps.addType(InArrayFunction.class);
            caps.addType(FilterFunction_equalTo.class);
            caps.addType(FilterFunction_buffer.class);
        }
        caps.addType(NativeFilter.class);
        return caps;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
            } else {
                this.visitComparisonSpatialOperator(filter, property, geometry, swapped, extraData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
        return extraData;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        try {
            this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
        return extraData;
    }

    void visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (filter instanceof DWithin && !swapped || filter instanceof Beyond && swapped) {
            this.out.write("ST_DWithin(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            this.out.write(this.toNativeUnits(filter));
            this.out.write(")");
        }
        if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
            this.out.write("ST_Distance(");
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(") > ");
            this.out.write(this.toNativeUnits(filter));
        }
    }

    private String toNativeUnits(DistanceBufferOperator operator) {
        double distance = this.isCurrentGeography() ? DistanceBufferUtil.getDistanceInMeters((DistanceBufferOperator)operator) : (this.delegate instanceof PostgisPSFilterToSql ? ((PostgisPSFilterToSql)this.delegate).getDistanceInNativeUnits(operator) : ((PostgisFilterToSQL)this.delegate).getDistanceInNativeUnits(operator));
        return String.valueOf(distance);
    }

    void visitComparisonSpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (this.isCurrentGeography()) {
            if (this.isWorld(geometry = this.clipToWorld(geometry))) {
                this.out.write(" TRUE ");
                return;
            }
            if (this.isEmpty(geometry)) {
                if (!(filter instanceof Disjoint)) {
                    this.out.write(" FALSE ");
                } else {
                    this.out.write(" TRUE ");
                }
                return;
            }
        }
        if (filter instanceof BBOX3D) {
            property.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(" &&& ");
            BBOX3D bbox = (BBOX3D)filter;
            BoundingBox3D bounds = bbox.getBounds();
            this.out.write("ST_Makeline(ST_MakePoint(");
            this.out.write(bounds.getMinX() + "," + bounds.getMinY() + "," + bounds.getMinZ());
            this.out.write("), ST_MakePoint(");
            this.out.write(bounds.getMaxX() + "," + bounds.getMaxY() + "," + bounds.getMaxZ());
            this.out.write("))");
        } else {
            if (!(filter instanceof Disjoint)) {
                if (this.encodeBBOXFilterAsEnvelope && !this.isCurrentGeography()) {
                    this.out.write("ST_envelope(");
                }
                property.accept((ExpressionVisitor)this.delegate, extraData);
                if (this.encodeBBOXFilterAsEnvelope && !this.isCurrentGeography()) {
                    this.out.write(")");
                }
                this.out.write(" && ");
                geometry.accept((ExpressionVisitor)this.delegate, extraData);
                if (filter instanceof BBOX && this.looseBBOXEnabled) {
                    return;
                }
                this.out.write(" AND ");
            }
            this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
        }
    }

    void visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) throws IOException {
        if (!DISABLE_CURVE_ACCURATE_INTERSECTION.booleanValue() && (filter instanceof Intersects || filter instanceof BBOX || filter instanceof Disjoint) && (this.mayHaveCurves(e1) || this.mayHaveCurves(e2))) {
            this.writeCurveIntersection(filter, e1, e2, swapped, extraData);
            return;
        }
        Object closingParenthesis = ")";
        if (filter instanceof Equals) {
            this.out.write("ST_Equals");
        } else if (filter instanceof Disjoint) {
            this.out.write("NOT (ST_Intersects");
            closingParenthesis = (String)closingParenthesis + ")";
        } else if (filter instanceof Intersects || filter instanceof BBOX) {
            this.out.write("ST_Intersects");
        } else if (filter instanceof Crosses) {
            this.out.write("ST_Crosses");
        } else if (filter instanceof Within) {
            if (swapped) {
                this.out.write("ST_Contains");
            } else {
                this.out.write("ST_Within");
            }
        } else if (filter instanceof Contains) {
            if (swapped) {
                this.out.write("ST_Within");
            } else {
                this.out.write("ST_Contains");
            }
        } else if (filter instanceof Overlaps) {
            this.out.write("ST_Overlaps");
        } else if (filter instanceof Touches) {
            this.out.write("ST_Touches");
        } else {
            throw new RuntimeException("Unsupported filter type " + filter.getClass());
        }
        this.out.write("(");
        e1.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(", ");
        e2.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write((String)closingParenthesis);
    }

    private void writeCurveIntersection(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) throws IOException {
        this.out.write("ST_Distance(");
        e1.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(", ");
        e2.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(") ");
        if (filter instanceof Disjoint) {
            this.out.write("> 0");
        } else {
            this.out.write("= 0");
        }
    }

    private boolean mayHaveCurves(Expression ex) {
        if (ex instanceof Literal) {
            Object value = ex.evaluate(null, Geometry.class);
            return value instanceof CurvedGeometry || value != null && (Geometry.class.equals(value.getClass()) || GeometryCollection.class.equals(value.getClass()));
        }
        if (ex instanceof PropertyName) {
            AttributeDescriptor ad = (AttributeDescriptor)ex.evaluate((Object)this.delegate.getFeatureType(), AttributeDescriptor.class);
            return Optional.ofNullable(ad).map(a -> a.getType()).map(t -> t.getBinding()).filter(c -> CurvedGeometry.class.isAssignableFrom((Class<?>)c) || Geometry.class.equals(c) || GeometryCollection.class.equals(c)).isPresent();
        }
        return false;
    }

    boolean isCurrentGeography() {
        GeometryDescriptor geom = null;
        if (this.delegate instanceof PostgisPSFilterToSql) {
            geom = ((PostgisPSFilterToSql)this.delegate).getCurrentGeometry();
        } else if (this.delegate instanceof PostgisFilterToSQL) {
            geom = ((PostgisFilterToSQL)this.delegate).getCurrentGeometry();
        }
        return geom != null && "geography".equals(geom.getUserData().get("org.geotools.jdbc.nativeTypeName"));
    }

    private Literal clipToWorld(Literal geometry) {
        Geometry g;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            Envelope env = g.getEnvelopeInternal();
            if (!WORLD.contains(env)) {
                g = this.sanitizePolygons(g.intersection((Geometry)JTS.toGeometry((Envelope)WORLD)));
            }
            if (Math.sqrt((env = g.getEnvelopeInternal()).getWidth() * env.getWidth() + env.getHeight() * env.getHeight()) >= 180.0) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                for (double lon = Math.floor(env.getMinX()); lon < env.getMaxX(); lon += 90.0) {
                    for (double lat = Math.floor(env.getMinY()); lat < env.getMaxY(); lat += 90.0) {
                        Polygon quadrant = JTS.toGeometry((Envelope)new Envelope(lon, lon + 90.0, lat, lat + 90.0));
                        Geometry cut = this.sanitizePolygons(g.intersection((Geometry)quadrant));
                        if (cut.isEmpty()) continue;
                        if (cut instanceof Polygon) {
                            polygons.add((Polygon)cut);
                            continue;
                        }
                        for (int i = 0; i < cut.getNumGeometries(); ++i) {
                            polygons.add((Polygon)cut.getGeometryN(i));
                        }
                    }
                }
                g = this.toPolygon(g.getFactory(), polygons);
            }
            geometry = CommonFactoryFinder.getFilterFactory(null).literal((Object)g);
        }
        return geometry;
    }

    private Geometry sanitizePolygons(Geometry geometry) {
        if (geometry == null || geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return geometry;
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        geometry.apply(geom -> {
            if (geom instanceof Polygon) {
                polygons.add((Polygon)geom);
            }
        });
        return this.toPolygon(geometry.getFactory(), polygons);
    }

    private Geometry toPolygon(GeometryFactory gf, List<Polygon> polygons) {
        if (polygons.isEmpty()) {
            return gf.createGeometryCollection(null);
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return gf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    private boolean isWorld(Literal geometry) {
        Geometry g;
        if (geometry != null && (g = (Geometry)geometry.evaluate(null, Geometry.class)) != null) {
            return JTS.toGeometry((Envelope)WORLD).equalsTopo(g.union());
        }
        return false;
    }

    private boolean isEmpty(Literal geometry) {
        if (geometry != null) {
            Geometry g = (Geometry)geometry.evaluate(null, Geometry.class);
            return g == null || g.isEmpty();
        }
        return false;
    }

    public String getFunctionName(Function function) {
        if (function instanceof FilterFunction_strLength || function instanceof LengthFunction) {
            return "char_length";
        }
        if (function instanceof FilterFunction_strToLowerCase) {
            return "lower";
        }
        if (function instanceof FilterFunction_strToUpperCase) {
            return "upper";
        }
        if (function instanceof FilterFunction_abs || function instanceof FilterFunction_abs_2 || function instanceof FilterFunction_abs_3 || function instanceof FilterFunction_abs_4) {
            return "abs";
        }
        return function.getName();
    }

    public boolean visitFunction(Function function, Object extraData) throws IOException {
        if (function instanceof DateDifferenceFunction) {
            TimeUnit timeUnit;
            Expression expression;
            Expression d1 = this.getParameter(function, 0, true);
            Expression d2 = this.getParameter(function, 1, true);
            List params = function.getParameters();
            double multiplyingFactor = 1000.0;
            if (params.size() == 3 && (expression = this.getParameter(function, 2, false)) instanceof Literal && (timeUnit = (TimeUnit)((Object)expression.evaluate(null, TimeUnit.class))) != TimeUnit.MILLISECONDS) {
                multiplyingFactor = 1.0 / (double)TimeUnit.SECONDS.convert(1L, timeUnit);
            }
            this.out.write("(extract(epoch from ");
            d1.accept((ExpressionVisitor)this.delegate, Date.class);
            this.out.write("::timestamp - ");
            d2.accept((ExpressionVisitor)this.delegate, Date.class);
            this.out.write(") * " + multiplyingFactor + ")");
        } else if (function instanceof FilterFunction_area) {
            Expression s1 = this.getParameter(function, 0, true);
            this.out.write("ST_Area(");
            s1.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strConcat) {
            Expression s1 = this.getParameter(function, 0, true);
            Expression s2 = this.getParameter(function, 1, true);
            this.out.write("(");
            s1.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(" || ");
            s2.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strEndsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression end = this.getParameter(function, 1, true);
            this.out.write("(");
            str.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(" LIKE ('%' || ");
            end.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write("))");
        } else if (function instanceof FilterFunction_strStartsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("(");
            str.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(" LIKE (");
            start.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(" || '%'))");
        } else if (function instanceof FilterFunction_strEqualsIgnoreCase) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("(lower(");
            first.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(") = lower(");
            second.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write("::text))");
        } else if (function instanceof FilterFunction_strIndexOf) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("(strpos(");
            first.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(", ");
            second.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(") - 1)");
        } else if (function instanceof FilterFunction_strSubstring) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            Expression end = this.getParameter(function, 2, true);
            this.out.write("substr(");
            string.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write(" + 1, (");
            end.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write(" - ");
            start.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write("))");
        } else if (function instanceof FilterFunction_strSubstringStart) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("substr(");
            string.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this.delegate, Integer.class);
            this.out.write(" + 1)");
        } else if (function instanceof FilterFunction_strTrim) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("trim(both ' ' from ");
            string.accept((ExpressionVisitor)this.delegate, String.class);
            this.out.write(")");
        } else if (function instanceof JsonPointerFunction) {
            this.encodeJsonPointer(function, extraData);
        } else if (function instanceof JsonArrayContainsFunction) {
            this.encodeJsonArrayContains(function);
        } else if (function instanceof FilterFunction_buffer) {
            this.encodeBuffer(function, extraData);
        } else {
            return false;
        }
        return true;
    }

    private void encodeBuffer(Function function, Object extraData) throws IOException {
        Expression source = this.getParameter(function, 0, true);
        Expression distance = this.getParameter(function, 1, true);
        this.out.write("ST_Buffer(");
        source.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(", ");
        distance.accept((ExpressionVisitor)this.delegate, extraData);
        this.out.write(")");
    }

    private void encodeJsonPointer(Function jsonPointer, Object extraData) throws IOException {
        Expression json = this.getParameter(jsonPointer, 0, true);
        Expression pointer = this.getParameter(jsonPointer, 1, true);
        if (json instanceof PropertyName && pointer instanceof Literal) {
            boolean needCast;
            boolean bl = needCast = extraData != null && extraData instanceof Class && !extraData.equals(String.class);
            if (needCast) {
                this.out.write(40);
            }
            json.accept((ExpressionVisitor)this.delegate, null);
            this.out.write(" ::json ");
            String strPointer = ((Literal)pointer).getValue().toString();
            List pointerEl = Stream.of(strPointer.split("/")).filter(p -> !p.equals("")).collect(Collectors.toList());
            for (int i = 0; i < pointerEl.size(); ++i) {
                String p2 = (String)pointerEl.get(i);
                if (i != pointerEl.size() - 1) {
                    this.out.write(" -> ");
                } else {
                    this.out.write(" ->> ");
                }
                String preparedLiteral = this.prepareInputLiteralForExpression(p2);
                LiteralExpressionImpl elPointer = new LiteralExpressionImpl((Object)preparedLiteral);
                Class binding = NumberUtils.isParsable((String)p2) ? Integer.class : String.class;
                elPointer.accept((ExpressionVisitor)this.delegate, binding);
            }
            if (needCast) {
                this.out.write(41);
                this.out.write(this.cast("", (Class)extraData));
            }
        }
    }

    private String prepareInputLiteralForExpression(String inputLiteral) {
        String contentBetween;
        if (inputLiteral.length() < 2) {
            return inputLiteral;
        }
        char firstChar = inputLiteral.charAt(0);
        char lastChar = inputLiteral.charAt(inputLiteral.length() - 1);
        if (firstChar == '\'' && lastChar == '\'' && NumberUtils.isParsable((String)(contentBetween = inputLiteral.substring(1, inputLiteral.length() - 1)))) {
            return contentBetween;
        }
        return inputLiteral;
    }

    public String buildJsonFromStrPointer(String[] pointers, int index, Expression expected) {
        if (pointers[index].isEmpty()) {
            return this.buildJsonFromStrPointer(pointers, index + 1, expected);
        }
        if (index == pointers.length - 1) {
            Object strExpected = FilterToSqlHelper.escapeJsonLiteral((String)expected.evaluate(null, String.class));
            if (this.getBaseType(expected).isAssignableFrom(String.class)) {
                strExpected = "\"" + (String)strExpected + "\"";
            }
            return String.format("\"%s\": [%s]", pointers[index], strExpected);
        }
        String jsonPointers = this.buildJsonFromStrPointer(pointers, index + 1, expected);
        return String.format("\"%s\": { %s }", pointers[index], jsonPointers);
    }

    private void encodeJsonArrayContains(Function jsonArrayContains) throws IOException {
        PropertyName column = (PropertyName)this.getParameter(jsonArrayContains, 0, true);
        Literal jsonPath = (Literal)this.getParameter(jsonArrayContains, 1, true);
        Expression expected = this.getParameter(jsonArrayContains, 2, true);
        String[] strJsonPath = FilterToSqlHelper.escapeJsonLiteral(jsonPath.getValue().toString()).split("/");
        if (strJsonPath.length > 0) {
            if (this.jsonPathExistsSupported) {
                this.out.write("jsonb_path_exists(");
                column.accept((ExpressionVisitor)this.delegate, null);
                this.out.write("::jsonb, '$");
                this.out.write(this.constructPath(strJsonPath));
                this.out.write(" ? ");
                this.out.write(this.constructEquality(strJsonPath, expected));
                this.out.write("')");
            } else {
                column.accept((ExpressionVisitor)this.delegate, null);
                this.out.write("::jsonb @> '{ ");
                this.out.write(this.buildJsonFromStrPointer(strJsonPath, 0, expected));
                this.out.write(" }'::jsonb");
            }
        } else {
            throw new IllegalArgumentException("Cannot encode filter Invalid pointer " + jsonPath.getValue());
        }
    }

    private String constructEquality(String[] jsonPath, Expression expected) {
        int lastIndex = jsonPath.length - 1;
        Object value = ((LiteralExpressionImpl)expected).getValue();
        if (value instanceof Integer) {
            return String.format("(@.%s == %d)", jsonPath[lastIndex], (Integer)value);
        }
        if (value instanceof Float) {
            return String.format("(@.%s == %f)", jsonPath[lastIndex], (Float)value);
        }
        if (value instanceof Double) {
            return String.format("(@.%s == %f)", jsonPath[lastIndex], (Double)value);
        }
        return String.format("(@.%s == \"%s\")", jsonPath[lastIndex], value);
    }

    private String constructPath(String[] jsonPath) {
        StringJoiner joiner = new StringJoiner(".");
        for (int i = 0; i < jsonPath.length - 1; ++i) {
            joiner.add(jsonPath[i]);
        }
        return joiner.toString();
    }

    private static String escapeJsonLiteral(String literal) {
        return EscapeSql.escapeLiteral((String)literal, (boolean)true, (boolean)true);
    }

    Expression getParameter(Function function, int idx, boolean mandatory) {
        List params = function.getParameters();
        if ((params == null || params.size() <= idx) && mandatory) {
            throw new IllegalArgumentException("Missing parameter number " + (idx + 1) + "for function " + function.getName() + ", cannot encode in SQL");
        }
        return (Expression)params.get(idx);
    }

    public String cast(String property, Class target) {
        if (String.class.equals((Object)target)) {
            return property + "::text";
        }
        if (Short.class.equals((Object)target) || Byte.class.equals((Object)target)) {
            return property + "::smallint";
        }
        if (Integer.class.equals((Object)target)) {
            return property + "::integer";
        }
        if (Long.class.equals((Object)target)) {
            return property + "::bigint";
        }
        if (Float.class.equals((Object)target)) {
            return property + "::real";
        }
        if (Double.class.equals((Object)target)) {
            return property + "::float8";
        }
        if (BigInteger.class.equals((Object)target)) {
            return property + "::numeric";
        }
        if (BigDecimal.class.equals((Object)target)) {
            return property + "::decimal";
        }
        if (Double.class.equals((Object)target)) {
            return property + "::float8";
        }
        if (Time.class.isAssignableFrom(target)) {
            return property + "::time";
        }
        if (Timestamp.class.isAssignableFrom(target)) {
            return property + "::timestamp";
        }
        if (java.sql.Date.class.isAssignableFrom(target)) {
            return property + "::date";
        }
        if (Date.class.isAssignableFrom(target)) {
            return property + "::timesamp";
        }
        return property;
    }

    boolean isArray(Expression exp) {
        if (exp instanceof Literal) {
            Object value = exp.evaluate(null);
            return value != null && value.getClass().isArray();
        }
        return false;
    }

    boolean isNull(Expression exp) {
        return exp instanceof Literal && exp.evaluate(null) == null || exp instanceof NilExpression;
    }

    boolean isArray(Class clazz) {
        return clazz != null && clazz.isArray();
    }

    boolean isArrayType(Expression exp) {
        return this.isArray(exp) || this.delegate.getExpressionType(exp).isArray();
    }

    void visitArrayComparison(BinaryComparisonOperator filter, Expression left, Expression right, Class rightContext, Class leftContext, String type) {
        String leftCast = "";
        String rightCast = "";
        if (left instanceof PropertyName) {
            rightCast = this.getArrayTypeCast((PropertyName)left);
        }
        if (right instanceof PropertyName) {
            leftCast = this.getArrayTypeCast((PropertyName)right);
        }
        try {
            MultiValuedFilter.MatchAction matchAction = filter.getMatchAction();
            if (!(matchAction != MultiValuedFilter.MatchAction.ANY && matchAction != MultiValuedFilter.MatchAction.ONE || this.isArray(left) || this.isArray(right))) {
                if ("=".equalsIgnoreCase(type) && !this.isNull(left) && !this.isNull(right)) {
                    Object leftArrayContext = this.getArrayComparisonContext(left, right, leftContext);
                    this.writeBinaryExpressionMember(left, leftArrayContext);
                    this.out.write(leftCast);
                    this.out.write(" && ");
                    Object rightArrayContext = this.getArrayComparisonContext(right, left, rightContext);
                    this.writeBinaryExpressionMember(right, rightArrayContext);
                    this.out.write(rightCast);
                } else {
                    if (left instanceof PropertyName) {
                        rightContext = rightContext.getComponentType();
                    }
                    if (right instanceof PropertyName) {
                        leftContext = leftContext.getComponentType();
                    }
                    boolean isPropertyLeft = left instanceof PropertyName;
                    boolean isPropertyRight = right instanceof PropertyName;
                    if (matchAction == MultiValuedFilter.MatchAction.ANY) {
                        this.out.write("EXISTS ( SELECT * from unnest(");
                    } else {
                        this.out.write("( SELECT count(*) from unnest(");
                    }
                    if (isPropertyLeft) {
                        left.accept((ExpressionVisitor)this.delegate, null);
                    } else {
                        right.accept((ExpressionVisitor)this.delegate, null);
                    }
                    this.out.write(") WHERE ");
                    if (isPropertyLeft && this.isNull(right) || isPropertyRight && this.isNull(left) && ("=".equalsIgnoreCase(type) || "!=".equalsIgnoreCase(type))) {
                        if ("=".equalsIgnoreCase(type)) {
                            this.out.write("unnest is NULL");
                        } else if ("!=".equalsIgnoreCase(type)) {
                            this.out.write("unnest is NOT NULL");
                        }
                    } else if (isPropertyLeft) {
                        this.out.write("unnest");
                        this.out.write(" " + type + " ");
                        this.writeBinaryExpressionMember(right, rightContext);
                    } else {
                        this.writeBinaryExpressionMember(left, leftContext);
                        this.out.write(" " + type + " ");
                        this.out.write("unnest");
                    }
                    if (matchAction == MultiValuedFilter.MatchAction.ONE) {
                        this.out.write(") = 1");
                    } else {
                        this.out.write(")");
                    }
                }
            } else if (matchAction == MultiValuedFilter.MatchAction.ALL || this.isArray(left) || this.isArray(right)) {
                Object leftArrayContext = this.getArrayComparisonContext(left, right, leftContext);
                this.writeBinaryExpressionMember(left, leftArrayContext);
                this.out.write(leftCast);
                this.out.write(" " + type + " ");
                Object rightArrayContext = this.getArrayComparisonContext(right, left, rightContext);
                this.writeBinaryExpressionMember(right, rightArrayContext);
                this.out.write(rightCast);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to write out SQL", ioe);
        }
    }

    private Object getArrayComparisonContext(Expression thisExpression, Expression otherExpression, Class context) {
        AttributeDescriptor ad;
        if (this.delegate instanceof PreparedFilterToSQL && thisExpression instanceof Literal && otherExpression instanceof PropertyName && (ad = (AttributeDescriptor)otherExpression.evaluate((Object)this.delegate.getFeatureType(), AttributeDescriptor.class)) != null) {
            return ad;
        }
        return context;
    }

    private void writeBinaryExpressionMember(Expression exp, Object context) throws IOException {
        if (context != null && exp instanceof BinaryExpression) {
            this.writeBinaryExpression(exp, context);
        } else {
            exp.accept((ExpressionVisitor)this.delegate, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBinaryExpression(Expression e, Object context) throws IOException {
        Writer tmp = this.out;
        try {
            this.out = new StringWriter();
            this.out.write("(");
            e.accept((ExpressionVisitor)this.delegate, null);
            this.out.write(")");
            if (context instanceof Class) {
                tmp.write(this.cast(this.out.toString(), (Class)context));
            } else {
                tmp.write(this.out.toString());
            }
        }
        finally {
            this.out = tmp;
        }
    }

    String getArrayTypeCast(PropertyName pn) {
        String typeName;
        Object value;
        AttributeDescriptor at = (AttributeDescriptor)pn.evaluate((Object)this.delegate.getFeatureType(), AttributeDescriptor.class);
        if (at != null && (value = at.getUserData().get("org.geotools.jdbc.nativeTypeName")) instanceof String && (typeName = (String)value).startsWith("_")) {
            return "::" + typeName.substring(1) + "[]";
        }
        return "";
    }

    public void visitArrayBetween(PropertyIsBetween filter, Class context, Object extraData) {
        Expression expr = filter.getExpression();
        Expression lowerbounds = filter.getLowerBoundary();
        Expression upperbounds = filter.getUpperBoundary();
        try {
            MultiValuedFilter.MatchAction matchAction = filter.getMatchAction();
            if (matchAction == MultiValuedFilter.MatchAction.ANY) {
                this.out.write("EXISTS ( SELECT * from unnest(");
            } else {
                this.out.write("( SELECT count(*) from unnest(");
            }
            expr.accept((ExpressionVisitor)this.delegate, null);
            this.out.write(") WHERE unnest BETWEEN ");
            lowerbounds.accept((ExpressionVisitor)this.delegate, (Object)context);
            this.out.write(" AND ");
            upperbounds.accept((ExpressionVisitor)this.delegate, (Object)context);
            if (matchAction == MultiValuedFilter.MatchAction.ONE) {
                this.out.write(") = 1");
            } else if (matchAction == MultiValuedFilter.MatchAction.ALL) {
                this.out.write(") = (SELECT COUNT(*) FROM unnest(");
                expr.accept((ExpressionVisitor)this.delegate, null);
                this.out.write("))");
            } else {
                this.out.write(")");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    private String getPrimaryKeyColumnsAsCommaSeparatedList(List<PrimaryKeyColumn> pkColumns, SQLDialect dialect) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (PrimaryKeyColumn c : pkColumns) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            dialect.encodeColumnName(null, c.getName(), sb);
        }
        return sb.toString();
    }

    public Object visit(InArrayFunction filter, Object extraData) {
        Expression candidate = this.getParameter((Function)filter, 0, true);
        Expression array = this.getParameter((Function)filter, 1, true);
        Class<?> arrayType = this.getBaseType(array);
        Class<?> candidateType = this.getBaseType(candidate);
        String castToArrayType = "";
        if (!(arrayType == null || candidateType != null && candidateType.equals(arrayType))) {
            castToArrayType = this.cast("", arrayType);
        }
        try {
            candidate.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(castToArrayType);
            this.out.write("=any(");
            array.accept((ExpressionVisitor)this.delegate, extraData);
            this.out.write(")");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    public Object visit(FilterFunction_equalTo filter, Object extraData) {
        Expression left = this.getParameter((Function)filter, 0, true);
        Expression right = this.getParameter((Function)filter, 1, true);
        Expression type = this.getParameter((Function)filter, 2, true);
        String matchType = (String)type.evaluate(null);
        PropertyIsEqualTo equal = CommonFactoryFinder.getFilterFactory(null).equal(left, right, false, MultiValuedFilter.MatchAction.valueOf((String)matchType));
        if (this.isArrayType(left) && this.isArrayType(right) && matchType.equalsIgnoreCase("ANY")) {
            this.visitArrayComparison((BinaryComparisonOperator)CommonFactoryFinder.getFilterFactory(null).equal(left, right, false, MultiValuedFilter.MatchAction.valueOf((String)matchType)), left, right, null, null, "&&");
        } else {
            equal.accept((FilterVisitor)this.delegate, extraData);
        }
        return extraData;
    }

    private Class<?> getBaseType(Expression expr) {
        Object value;
        Class<?> type = this.delegate.getExpressionType(expr);
        if (type == null && expr instanceof Literal && (value = this.delegate.evaluateLiteral((Literal)expr, Object.class)) != null) {
            type = value.getClass();
        }
        if (this.isArray(type)) {
            type = type.getComponentType();
        }
        return type;
    }

    public Object visit(FilterFunction_pgNearest filter, Object extraData, NearestHelperContext ctx) {
        SQLDialect pgDialect = ctx.getPgDialect();
        Expression geometryExp = this.getParameter((Function)filter, 0, true);
        Expression numNearest = this.getParameter((Function)filter, 1, true);
        try {
            List pkColumns = this.delegate.getPrimaryKey().getColumns();
            if (pkColumns == null || pkColumns.isEmpty()) {
                throw new UnsupportedOperationException("Unsupported usage of Postgis Nearest Operator: table with no primary key");
            }
            String pkColumnsAsString = this.getPrimaryKeyColumnsAsCommaSeparatedList(pkColumns, pgDialect);
            StringBuffer sb = new StringBuffer();
            sb.append(" (").append(pkColumnsAsString).append(")").append(" in (select ").append(pkColumnsAsString).append(" from ");
            if (this.delegate.getDatabaseSchema() != null) {
                pgDialect.encodeSchemaName(this.delegate.getDatabaseSchema(), sb);
                sb.append(".");
            }
            pgDialect.encodeTableName(this.delegate.getPrimaryKey().getTableName(), sb);
            sb.append(" order by ");
            pgDialect.encodeColumnName(null, this.delegate.getFeatureType().getGeometryDescriptor().getLocalName(), sb);
            sb.append(" <-> ");
            Geometry geomValue = (Geometry)this.delegate.evaluateLiteral((Literal)geometryExp, Geometry.class);
            ctx.encodeGeometryValue.accept(geomValue, sb);
            sb.append(" limit ");
            int numFeatures = ((Number)numNearest.evaluate(null, Number.class)).intValue();
            sb.append(numFeatures);
            sb.append(")");
            this.out.write(sb.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    public InArrayFunction getInArray(PropertyIsEqualTo filter) {
        Expression expr1 = filter.getExpression1();
        Expression expr2 = filter.getExpression2();
        if (expr2 instanceof InArrayFunction) {
            return (InArrayFunction)expr2;
        }
        if (expr1 instanceof InArrayFunction) {
            return (InArrayFunction)expr1;
        }
        return null;
    }

    public FilterFunction_equalTo getEqualTo(PropertyIsEqualTo filter) {
        Expression expr1 = filter.getExpression1();
        Expression expr2 = filter.getExpression2();
        if (expr2 instanceof FilterFunction_equalTo) {
            return (FilterFunction_equalTo)expr2;
        }
        if (expr1 instanceof FilterFunction_equalTo) {
            return (FilterFunction_equalTo)expr1;
        }
        return null;
    }

    public FilterFunction_pgNearest getNearestFilter(PropertyIsEqualTo filter) {
        Expression expr1 = filter.getExpression1();
        Expression expr2 = filter.getExpression2();
        if (expr2 instanceof FilterFunction_pgNearest) {
            Expression tmp = expr1;
            expr1 = expr2;
            expr2 = tmp;
        }
        if (expr1 instanceof FilterFunction_pgNearest) {
            if (!(expr2 instanceof Literal)) {
                throw new UnsupportedOperationException("Unsupported usage of Nearest Operator: it can be compared only to a Boolean \"true\" value");
            }
            Boolean nearest = (Boolean)this.delegate.evaluateLiteral((Literal)expr2, Boolean.class);
            if (nearest == null || !nearest.booleanValue()) {
                throw new UnsupportedOperationException("Unsupported usage of Nearest Operator: it can be compared only to a Boolean \"true\" value");
            }
            return (FilterFunction_pgNearest)expr1;
        }
        return null;
    }

    public Integer getFeatureTypeGeometrySRID() {
        return (Integer)this.delegate.getFeatureType().getGeometryDescriptor().getUserData().get("nativeSRID");
    }

    public Integer getFeatureTypeGeometryDimension() {
        GeometryDescriptor descriptor = this.delegate.getFeatureType().getGeometryDescriptor();
        return (Integer)descriptor.getUserData().get(Hints.COORDINATE_DIMENSION);
    }

    public boolean isSupportedEqualFunction(PropertyIsEqualTo filter) {
        FilterFunction_pgNearest nearest = this.getNearestFilter(filter);
        InArrayFunction inArray = this.getInArray(filter);
        FilterFunction_equalTo equalTo = this.getEqualTo(filter);
        return nearest != null || inArray != null || equalTo != null;
    }

    public Object visitSupportedEqualFunction(PropertyIsEqualTo filter, SQLDialect dialect, BiConsumer<Geometry, StringBuffer> encodeGeometryValue, Object extraData) {
        FilterFunction_pgNearest nearest = this.getNearestFilter(filter);
        InArrayFunction inArray = this.getInArray(filter);
        FilterFunction_equalTo equalTo = this.getEqualTo(filter);
        if (nearest != null) {
            return this.visit(nearest, extraData, new NearestHelperContext(dialect, encodeGeometryValue));
        }
        if (inArray != null) {
            return this.visit(inArray, extraData);
        }
        if (equalTo != null) {
            return this.visit(equalTo, extraData);
        }
        return null;
    }

    private boolean postgresMajorVersionIsEqualOrGreaterThan(Version currentVersion, Version expectedVersion) {
        if (currentVersion != null && expectedVersion != null) {
            Comparable current = currentVersion.getMajor();
            Comparable expected = expectedVersion.getMajor();
            if (current instanceof Integer && expected instanceof Integer) {
                return (Integer)current >= (Integer)expected;
            }
        }
        return false;
    }

    public static class NearestHelperContext {
        private SQLDialect pgDialect;
        private BiConsumer<Geometry, StringBuffer> encodeGeometryValue;

        public NearestHelperContext(SQLDialect pgDialect, BiConsumer<Geometry, StringBuffer> encodeGeometryValue) {
            this.pgDialect = pgDialect;
            this.encodeGeometryValue = encodeGeometryValue;
        }

        public SQLDialect getPgDialect() {
            return this.pgDialect;
        }

        public void setPgDialect(SQLDialect pgDialect) {
            this.pgDialect = pgDialect;
        }

        public BiConsumer<Geometry, StringBuffer> getEncodeGeometryValue() {
            return this.encodeGeometryValue;
        }

        public void setEncodeGeometryValue(BiConsumer<Geometry, StringBuffer> encodeGeometryValue) {
            this.encodeGeometryValue = encodeGeometryValue;
        }
    }
}

