/*
 * Decompiled with CFR 0.152.
 */
package v445;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.migration.DatabaseMigrationException;
import org.fao.geonet.utils.Log;
import org.springframework.util.StringUtils;

public class DoiServerDatabaseMigration
extends DatabaseMigrationTask {
    public void update(Connection connection) throws SQLException, DatabaseMigrationException {
        Log.debug((String)"geonetwork.database", (Object)"DoiServerDatabaseMigration");
        boolean doiEnabled = false;
        String doiUrl = "";
        String doiUsername = "";
        String doiPassword = "";
        String doiKey = "";
        String doiLandingPageTemplate = "";
        String doiPublicUrl = "";
        String doiPattern = "";
        try (Statement statement = connection.createStatement();){
            String selectDoiSerttingsSQL = "SELECT name, value FROM Settings WHERE name LIKE 'system/publication/doi%'";
            String columnForName = "name";
            String columnForValue = "value";
            ResultSet resultSet = statement.executeQuery("SELECT name, value FROM Settings WHERE name LIKE 'system/publication/doi%'");
            while (resultSet.next()) {
                if (resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doienabled")) {
                    doiEnabled = resultSet.getString(columnForValue).equalsIgnoreCase("true");
                    continue;
                }
                if (resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doiurl")) {
                    doiUrl = resultSet.getString(columnForValue);
                    continue;
                }
                if (resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doiusername")) {
                    doiUsername = resultSet.getString(columnForValue);
                    continue;
                }
                if (resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doipassword")) {
                    doiPassword = resultSet.getString(columnForValue);
                    continue;
                }
                if (resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doikey")) {
                    doiKey = resultSet.getString(columnForValue);
                    continue;
                }
                if (resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doilandingpagetemplate")) {
                    doiLandingPageTemplate = resultSet.getString(columnForValue);
                    continue;
                }
                if (resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doipublicurl")) {
                    doiPublicUrl = resultSet.getString(columnForValue);
                    continue;
                }
                if (!resultSet.getString(columnForName).equalsIgnoreCase("system/publication/doi/doipattern")) continue;
                doiPattern = resultSet.getString(columnForValue);
            }
        }
        if (doiEnabled) {
            boolean createDoiServer;
            boolean bl = createDoiServer = StringUtils.hasLength((String)doiUrl) && StringUtils.hasLength((String)doiUsername) && StringUtils.hasLength((String)doiPassword) && StringUtils.hasLength((String)doiKey) && StringUtils.hasLength((String)doiPattern);
            if (createDoiServer) {
                try (PreparedStatement update = connection.prepareStatement("INSERT INTO doiservers (id, landingpagetemplate, name, url, username, password, pattern, prefix, publicurl) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                    update.setInt(1, 1);
                    update.setString(2, doiLandingPageTemplate);
                    update.setString(3, "Default DOI server");
                    update.setString(4, doiUrl);
                    update.setString(5, doiUsername);
                    update.setString(6, doiPassword);
                    update.setString(7, doiPattern);
                    update.setString(8, doiKey);
                    update.setString(9, doiPublicUrl);
                    update.execute();
                }
                catch (BatchUpdateException e) {
                    connection.rollback();
                    Log.error((String)"geonetwork", (String)("Error occurred while creating the DOI server:" + e.getMessage()), (Throwable)e);
                    SQLException next = e.getNextException();
                    while (next != null) {
                        Log.error((String)"geonetwork", (String)("Next error: " + next.getMessage()), (Throwable)next);
                        next = e.getNextException();
                    }
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    connection.rollback();
                    throw new Error(e);
                }
                this.deleteDoiSettings(connection);
                connection.commit();
                Log.info((String)"geonetwork.database", (Object)"Migration: migrated DOI server");
            }
        } else {
            this.deleteDoiSettings(connection);
            connection.commit();
            Log.info((String)"geonetwork.database", (Object)"Migration: deleted DOI settings");
        }
    }

    private void deleteDoiSettings(Connection connection) throws SQLException {
        try (PreparedStatement delete = connection.prepareStatement("DELETE FROM Settings WHERE name LIKE 'system/publication/doi%' and name != 'system/publication/doi/doienabled'");){
            delete.execute();
        }
        catch (BatchUpdateException e) {
            connection.rollback();
            Log.error((String)"geonetwork", (String)("Error occurred while deleting the DOI old settings:" + e.getMessage()), (Throwable)e);
            SQLException next = e.getNextException();
            while (next != null) {
                Log.error((String)"geonetwork", (String)("Next error: " + next.getMessage()), (Throwable)next);
                next = e.getNextException();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            connection.rollback();
            throw new Error(e);
        }
    }
}

