/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Env;
import org.fao.geonet.utils.Log;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate5.encryptor.HibernatePBEEncryptorRegistry;
import org.springframework.beans.factory.annotation.Autowired;

public class EncryptorInitializer {
    private static final String LOG_MODULE = "geonetwork.encryptor";
    private static final String ALGORITHM_KEY = "encryptor.algorithm";
    private static final String PASSWORD_KEY = "encryptor.password";
    private static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    @Autowired
    StandardPBEStringEncryptor encryptor;
    @Autowired
    DataSource dataSource;
    private boolean firstInitialSetupFlag;

    public void setFirstInitialSetupFlag(boolean firstInitialSetupFlag) {
        this.firstInitialSetupFlag = firstInitialSetupFlag;
    }

    public void init(GeonetworkDataDirectory dataDirectory) throws Exception {
        String encryptorPassword;
        boolean updateConfiguration;
        String encryptorAlgorithm;
        PropertiesConfiguration conf = this.getEncryptorPropertiesFile(dataDirectory);
        String encryptorAlgorithmPropFile = (String)conf.getProperty(ALGORITHM_KEY);
        String encryptorPasswordPropFile = (String)conf.getProperty(PASSWORD_KEY);
        if (StringUtils.isEmpty((String)encryptorAlgorithmPropFile)) {
            encryptorAlgorithm = encryptorAlgorithmPropFile = Env.getPropertyFromEnv((String)ALGORITHM_KEY, (String)DEFAULT_ALGORITHM);
            updateConfiguration = true;
        } else {
            String encryptorAlgorithmFromEnv = Env.getPropertyFromEnv((String)ALGORITHM_KEY, (String)"");
            encryptorAlgorithm = StringUtils.isNotEmpty((String)encryptorAlgorithmFromEnv) ? encryptorAlgorithmFromEnv : encryptorAlgorithmPropFile;
            boolean bl = updateConfiguration = !encryptorAlgorithm.equals(encryptorAlgorithmPropFile);
        }
        if (StringUtils.isEmpty((String)encryptorPasswordPropFile)) {
            encryptorPasswordPropFile = Env.getPropertyFromEnv((String)PASSWORD_KEY, (String)"");
            if (StringUtils.isEmpty((String)encryptorPasswordPropFile)) {
                if (!this.firstInitialSetupFlag) {
                    Log.error((String)LOG_MODULE, (Object)String.format("Password database encryptor initialization error - could not locate encryptor password via encryption file %s or supplied properties/environment variable (%s). GeoNetwork can not decrypt passwords already stored in the database. Either recover the previous password and restart the application or manually null all existing encrypted passwords in the database and re-enter passwords via the application", conf.getPath(), PASSWORD_KEY));
                }
                Log.info((String)LOG_MODULE, (Object)"Generating a new random password for the database password encryptor");
                encryptorPasswordPropFile = RandomStringUtils.randomAlphanumeric((int)10);
            }
            encryptorPassword = encryptorPasswordPropFile;
            updateConfiguration = true;
        } else {
            String encryptorPasswordFromEnv = Env.getPropertyFromEnv((String)PASSWORD_KEY, (String)"");
            encryptorPassword = StringUtils.isNotEmpty((String)encryptorPasswordFromEnv) ? encryptorPasswordFromEnv : encryptorPasswordPropFile;
            updateConfiguration = updateConfiguration || !encryptorPassword.equals(encryptorPasswordPropFile);
        }
        Log.info((String)LOG_MODULE, (Object)String.format("Password database encryptor initialized - Keep the file %s safe and make a backup. When upgrading to a newer version of GeoNetwork the file must be restored, otherwise GeoNetwork will not be able to decrypt passwords already stored in the database.", conf.getPath()));
        this.encryptor.setAlgorithm(encryptorAlgorithm);
        this.encryptor.setPassword(encryptorPassword);
        try {
            this.encryptor.initialize();
        }
        catch (EncryptionInitializationException ex) {
            if (ex.getCause() instanceof NoSuchAlgorithmException) {
                Log.error((String)LOG_MODULE, (Object)String.format("Encryptor algorithm %s is not supported", encryptorAlgorithm));
            } else {
                Log.error((String)LOG_MODULE, (String)ex.getMessage(), (Throwable)ex);
            }
            throw new RuntimeException(String.format("Password encryptor could not be initialised, review the configuration in %s or the environment variables if provided.", conf.getPath()));
        }
        if (updateConfiguration) {
            conf.setProperty(ALGORITHM_KEY, (Object)encryptorAlgorithm);
            conf.setProperty(PASSWORD_KEY, (Object)encryptorPassword);
            String headerComment = "Generated at %s.";
            String date = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            conf.setHeader(String.format(headerComment, date));
            conf.save();
            if (!encryptorPassword.equals(encryptorPasswordPropFile) || !encryptorAlgorithm.equals(encryptorAlgorithmPropFile)) {
                Log.info((String)LOG_MODULE, (Object)"Password database encryptor - re-encrypting passwords stored in the database");
                StandardPBEStringEncryptor previousEncryptor = new StandardPBEStringEncryptor();
                previousEncryptor.setAlgorithm(encryptorAlgorithmPropFile);
                previousEncryptor.setPassword(encryptorPasswordPropFile);
                previousEncryptor.initialize();
                this.updateDb(previousEncryptor);
            } else if (this.firstInitialSetupFlag) {
                Log.info((String)LOG_MODULE, (Object)"Password database encryptor - encrypting passwords stored in the database");
                this.updateDb(null);
            }
        }
        HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
        registry.registerPBEStringEncryptor("STRING_ENCRYPTOR", (PBEStringEncryptor)this.encryptor);
    }

    private void updateDb(StandardPBEStringEncryptor previousEncryptor) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            String encryptedSettings = "SELECT name, value FROM Settings WHERE encrypted = 'y'";
            HashMap<String, String> updates = new HashMap<String, String>();
            try (ResultSet settingsResultSet = statement.executeQuery("SELECT name, value FROM Settings WHERE encrypted = 'y'");){
                int numberOfSettings = this.encryptDatabaseValuesStringId(previousEncryptor, updates, settingsResultSet);
                Log.debug((String)LOG_MODULE, (Object)("  Number of settings of type password to update: " + numberOfSettings));
            }
            catch (Exception ex) {
                Log.error((String)LOG_MODULE, (Object)"Error getting the settings' passwords for encrypting them");
                Log.error((String)LOG_MODULE, (Object)ex);
                ex.printStackTrace();
            }
            for (String key : updates.keySet()) {
                PreparedStatement pstmt = connection.prepareStatement("UPDATE Settings SET value=? WHERE name=?");
                pstmt.setString(1, (String)updates.get(key));
                pstmt.setString(2, key);
                pstmt.executeUpdate();
            }
            String encryptedHarvesterSettings = "SELECT name, value FROM HarvesterSettings WHERE name = 'password'";
            updates = new HashMap();
            try (ResultSet harvesterSettingsResultSet = statement.executeQuery("SELECT name, value FROM HarvesterSettings WHERE name = 'password'");){
                int numberOfHarvesterSettings = this.encryptDatabaseValuesStringId(previousEncryptor, updates, harvesterSettingsResultSet);
                Log.debug((String)LOG_MODULE, (Object)("  Number of harvester settings of type password to update: " + numberOfHarvesterSettings));
            }
            catch (Exception ex) {
                Log.error((String)LOG_MODULE, (Object)"Error getting the harvesters' passwords for encrypting them");
                Log.error((String)LOG_MODULE, (Object)ex);
                ex.printStackTrace();
            }
            for (String key : updates.keySet()) {
                PreparedStatement pstmt = connection.prepareStatement("UPDATE HarvesterSettings SET value=? WHERE name=?");
                pstmt.setString(1, (String)updates.get(key));
                pstmt.setString(2, key);
                pstmt.executeUpdate();
            }
            String encryptedMapServerPasswords = "SELECT id, password FROM Mapservers";
            HashMap<Integer, String> updatesMapServers = new HashMap<Integer, String>();
            try (ResultSet mapServerResultSet = statement.executeQuery("SELECT id, password FROM Mapservers");){
                int numberOfMapServers = this.encryptDatabaseValuesIntegerId(previousEncryptor, updatesMapServers, mapServerResultSet);
                Log.debug((String)LOG_MODULE, (Object)("  Number of map server passwords to update: " + numberOfMapServers));
            }
            catch (Exception ex) {
                Log.error((String)LOG_MODULE, (Object)"Error getting the map servers' passwords for encrypting them");
                Log.error((String)LOG_MODULE, (Object)ex);
                ex.printStackTrace();
            }
            for (Integer key : updatesMapServers.keySet()) {
                PreparedStatement pstmt = connection.prepareStatement("UPDATE Mapservers SET password=? WHERE id=?");
                pstmt.setString(1, (String)updatesMapServers.get(key));
                pstmt.setInt(2, key);
                pstmt.executeUpdate();
            }
            connection.commit();
        }
    }

    private int encryptDatabaseValuesIntegerId(StandardPBEStringEncryptor previousEncryptor, Map<Integer, String> updatedRows, ResultSet mapServerResultSet) throws SQLException {
        int numberOfRowsUpdated = 0;
        while (mapServerResultSet.next()) {
            Integer id = mapServerResultSet.getInt(1);
            String password = mapServerResultSet.getString(2);
            if (!StringUtils.isNotEmpty((String)password)) continue;
            if (previousEncryptor != null) {
                password = previousEncryptor.decrypt(password);
            }
            password = this.encryptor.encrypt(password);
            updatedRows.put(id, password);
            ++numberOfRowsUpdated;
        }
        return numberOfRowsUpdated;
    }

    private int encryptDatabaseValuesStringId(StandardPBEStringEncryptor previousEncryptor, Map<String, String> updates, ResultSet settingsResultSet) throws SQLException {
        int numberOfRowsUpdated = 0;
        while (settingsResultSet.next()) {
            String name = settingsResultSet.getString(1);
            String value = settingsResultSet.getString(2);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            if (previousEncryptor != null) {
                value = previousEncryptor.decrypt(value);
            }
            value = this.encryptor.encrypt(value);
            updates.put(name, value);
            ++numberOfRowsUpdated;
        }
        return numberOfRowsUpdated;
    }

    private PropertiesConfiguration getEncryptorPropertiesFile(GeonetworkDataDirectory dataDirectory) throws Exception {
        Path securityPropsPath = dataDirectory.getConfigDir().resolve("encryptor.properties");
        if (!Files.exists(securityPropsPath, new LinkOption[0])) {
            Files.createFile(securityPropsPath, new FileAttribute[0]);
        }
        return new PropertiesConfiguration(securityPropsPath.toFile());
    }
}

